/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal9Int
implements DrillSimpleFunc {
    @Param
    Decimal9Holder in;
    @Output
    IntHolder out;

    public void setup() {
    }

    public void eval() {
        int carry = DecimalUtility.getFirstFractionalDigit((int)this.in.value, (int)this.in.scale) > 4 ? 1 : 0;
        this.out.value = Math.abs((int)DecimalUtility.adjustScaleDivide((long)this.in.value, (int)this.in.scale)) + carry;
        if (this.in.value < 0) {
            this.out.value *= -1;
        }
    }
}

