/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL9", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal38SparseDecimal9
implements DrillSimpleFunc {
    @Param
    Decimal38SparseHolder in;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal9Holder out;

    public void setup() {
    }

    public void eval() {
        BigDecimal temp = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.in.buffer, (int)this.in.start, (int)6, (int)this.in.scale);
        temp = temp.setScale((int)this.scale.value, 4);
        this.out.value = temp.unscaledValue().intValue();
        this.out.precision = (int)this.precision.value;
        this.out.scale = (int)this.scale.value;
    }
}

