/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL28SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal38SparseDecimal28Sparse
implements DrillSimpleFunc {
    @Param
    Decimal38SparseHolder in;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Inject
    DrillBuf buffer;
    @Output
    Decimal28SparseHolder out;

    public void setup() {
        int size = 20;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        BigDecimal temp = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.in.buffer, (int)this.in.start, (int)6, (int)this.in.scale);
        temp = temp.setScale((int)this.scale.value, 4);
        this.out.precision = (int)this.precision.value;
        this.out.scale = (int)this.scale.value;
        this.out.buffer = this.buffer;
        this.out.start = 0;
        DecimalUtility.getSparseFromBigDecimal((BigDecimal)temp, (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)5);
    }
}

