/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castBIGINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal38SparseBigInt
implements DrillSimpleFunc {
    @Param
    Decimal38SparseHolder in;
    @Output
    BigIntHolder out;

    public void setup() {
    }

    public void eval() {
        int carry = DecimalUtility.getFirstFractionalDigit((DrillBuf)this.in.buffer, (int)this.in.scale, (int)this.in.start, (int)6) > 4 ? 1 : 0;
        int integerEndIndex = 6 - DecimalUtility.roundUp((int)this.in.scale);
        for (int i = 0; i < integerEndIndex; ++i) {
            this.out.value = this.out.value * 1000000000L + (long)Decimal38SparseHolder.getInteger(i, this.in.start, this.in.buffer);
        }
        this.out.value += (long)carry;
        if (Decimal38SparseHolder.getSign(this.in.start, this.in.buffer)) {
            this.out.value *= -1L;
        }
    }
}

