/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal28SparseVarChar
implements DrillSimpleFunc {
    @Param
    Decimal28SparseHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded((int)this.len.value);
    }

    public void eval() {
        int value;
        int index;
        StringBuilder str = new StringBuilder();
        int fractionalStartIndex = 5 - DecimalUtility.roundUp((int)this.in.scale);
        for (index = 0; index < fractionalStartIndex; ++index) {
            if (Decimal28SparseHolder.getInteger(index, this.in.start, this.in.buffer) != 0) break;
        }
        if (Decimal28SparseHolder.getSign(this.in.start, this.in.buffer) && index < 5) {
            str.append("-");
        }
        if (index == fractionalStartIndex) {
            str.append("0");
        }
        boolean fillZeroes = false;
        while (index < fractionalStartIndex) {
            value = Decimal28SparseHolder.getInteger(index++, this.in.start, this.in.buffer);
            if (fillZeroes) {
                str.append((CharSequence)DecimalUtility.toStringWithZeroes((int)value, (int)9));
                continue;
            }
            str.append(value);
            fillZeroes = true;
        }
        if (fractionalStartIndex < 5) {
            str.append(".");
            while (fractionalStartIndex < 4) {
                value = Decimal28SparseHolder.getInteger(fractionalStartIndex++, this.in.start, this.in.buffer);
                str.append((CharSequence)DecimalUtility.toStringWithZeroes((int)value, (int)9));
            }
            int actualDigits = this.in.scale % 9;
            int lastFractionalDigit = Decimal28SparseHolder.getInteger(4, this.in.start, this.in.buffer);
            if (actualDigits != 0) {
                str.append((CharSequence)DecimalUtility.toStringWithZeroes((int)(lastFractionalDigit /= (int)DecimalUtility.getPowerOfTen((int)(9 - actualDigits))), (int)actualDigits));
            } else {
                str.append((CharSequence)DecimalUtility.toStringWithZeroes((int)lastFractionalDigit, (int)9));
            }
        }
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, String.valueOf(str.substring(0, this.out.end)).getBytes());
    }
}

