/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL38SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal28SparseDecimal38Sparse
implements DrillSimpleFunc {
    @Param
    Decimal28SparseHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal38SparseHolder out;

    public void setup() {
        int size = 24;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        boolean sign = Decimal28SparseHolder.getSign(this.in.start, this.in.buffer);
        for (int i = 0; i < 6; ++i) {
            Decimal38SparseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        int inputIdx = 5 - 1;
        int outputIdx = 6 - 1;
        while (inputIdx >= 0) {
            Decimal38SparseHolder.setInteger(outputIdx, Decimal28SparseHolder.getInteger(inputIdx, this.in.start, this.in.buffer), this.out.start, this.out.buffer);
            --inputIdx;
            --outputIdx;
        }
        if (this.in.scale != this.out.scale) {
            DecimalUtility.roundDecimal((DrillBuf)this.out.buffer, (int)this.out.start, (int)6, (int)this.out.scale, (int)this.in.scale);
        }
        Decimal38SparseHolder.setSign(sign, this.out.start, this.out.buffer);
    }
}

