/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;

@FunctionTemplate(name="castDECIMAL28DENSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal28SparseDecimal28Dense
implements DrillSimpleFunc {
    @Param
    Decimal28SparseHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal28DenseHolder out;

    public void setup() {
        int size = 12;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        int actualDigits;
        this.out.buffer = this.buffer;
        this.out.start = 0;
        for (int i = 0; i < 3; ++i) {
            Decimal28DenseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        int[] intermediate = new int[5 - 1];
        int index = 5 - 1;
        if (this.in.scale > 0 && (actualDigits = this.in.scale % 9) > 0) {
            int paddedDigits = 9 - actualDigits;
            int paddedMask = (int)Math.pow(10.0, paddedDigits);
            int temp = Decimal28SparseHolder.getInteger(index, this.in.start, this.in.buffer) / paddedMask;
            --index;
            while (index >= 0) {
                int transferDigits = Decimal28SparseHolder.getInteger(index, this.in.start, this.in.buffer) % paddedMask;
                intermediate[index] = (int)((double)temp + Math.pow(10.0, actualDigits) * (double)transferDigits);
                temp = Decimal28SparseHolder.getInteger(index, this.in.start, this.in.buffer) / paddedMask;
                --index;
            }
        } else {
            int i = 1;
            while (true) {
                if (i >= 5) break;
                intermediate[i - 1] = Decimal28SparseHolder.getInteger(i, this.in.start, this.in.buffer);
                ++i;
            }
        }
        int size = (intermediate.length - 1) * 4 + 1;
        byte[] intermediateBytes = new byte[size];
        ByteBuffer wrapper = ByteBuffer.wrap(intermediateBytes);
        wrapper.put((byte)intermediate[0]);
        for (int i = 1; i < intermediate.length; ++i) {
            wrapper.put(ByteBuffer.allocate(4).putInt(intermediate[i]).array());
        }
        int[] mask = new int[]{3, 15, 63, 255};
        int maskIndex = 0;
        int shiftOrder = 2;
        index = size - 5;
        while (index >= 0) {
            byte shiftBits = (byte)((intermediateBytes[index] & mask[maskIndex]) << 8 - shiftOrder);
            int shiftOrder1 = index % 4 == 0 ? shiftOrder - 2 : shiftOrder;
            intermediateBytes[index + 1] = (byte)((intermediateBytes[index + 1] & 0xFF) >>> shiftOrder1 | shiftBits);
            if (--index % 4 != 0) continue;
            shiftOrder += 2;
            ++maskIndex;
        }
        int dstIndex = 0;
        this.out.buffer.setBytes(dstIndex, intermediateBytes, 1, size - 1);
        Decimal28DenseHolder.setSign(Decimal28SparseHolder.getSign(this.in.start, this.in.buffer), this.out.start, this.out.buffer);
    }
}

