/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;

@FunctionTemplate(name="castDECIMAL38SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal28DenseDecimal38Sparse
implements DrillSimpleFunc {
    @Param
    Decimal28DenseHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal38SparseHolder out;

    public void setup() {
        int size = 24;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        int srcIndex;
        int actualDigits;
        this.out.buffer = this.buffer;
        this.out.start = 0;
        for (int i = 0; i < 6; ++i) {
            Decimal38SparseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        Decimal38SparseHolder.setSign(Decimal28DenseHolder.getSign(this.in.start, this.in.buffer), this.out.start, this.out.buffer);
        byte[] intermediateBytes = new byte[3 * 4 + 1];
        int[] mask = new int[]{3, 15, 63, 255};
        int[] reverseMask = new int[]{252, 240, 192, 0};
        int maskIndex = 1;
        int shiftOrder = 4;
        byte shiftBits = (byte)((this.in.buffer.getByte(0) & 3) << shiftOrder);
        intermediateBytes[0] = (byte)((this.in.buffer.getByte(0) & 0x3C & 0xFF) >>> 2);
        int intermediateIndex = 1;
        int inputIndex = this.in.start + 1;
        while (true) {
            if (intermediateIndex >= 12) break;
            intermediateBytes[intermediateIndex] = (byte)(shiftBits | (this.in.buffer.getByte(inputIndex) & reverseMask[maskIndex] & 0xFF) >>> 8 - shiftOrder);
            shiftBits = (byte)((this.in.buffer.getByte(inputIndex) & mask[maskIndex]) << shiftOrder);
            ++inputIndex;
            if ((++intermediateIndex - 1) % 4 != 0) continue;
            shiftBits = (byte)((shiftBits & 0xFF) >>> 2);
            ++maskIndex;
            shiftOrder -= 2;
        }
        intermediateBytes[intermediateIndex] = shiftBits;
        int[] intermediate = new int[intermediateBytes.length / 4 + 1];
        ByteBuffer wrapper = ByteBuffer.wrap(intermediateBytes);
        intermediate[0] = wrapper.get(0);
        int intermediateIdx = 1;
        for (int i = 1; i < intermediate.length; ++i) {
            intermediate[i] = wrapper.getInt(intermediateIdx);
            intermediateIdx += 4;
        }
        int dstIndex = 6 - 1;
        if (this.in.scale > 0 && (actualDigits = this.in.scale % 9) > 0) {
            int paddedDigits = 9 - actualDigits;
            int padding = (int)Math.pow(10.0, paddedDigits);
            int transferDigitMask = (int)Math.pow(10.0, actualDigits);
            Decimal38SparseHolder.setInteger(dstIndex, intermediate[srcIndex] % transferDigitMask * padding, this.out.start, this.out.buffer);
            --dstIndex;
            for (srcIndex = intermediate.length - 1; srcIndex > 0; --srcIndex) {
                Decimal38SparseHolder.setInteger(dstIndex, intermediate[srcIndex] / transferDigitMask + intermediate[srcIndex - 1] % transferDigitMask * padding, this.out.start, this.out.buffer);
                --dstIndex;
            }
            Decimal38SparseHolder.setInteger(dstIndex, intermediate[0] / transferDigitMask, this.out.start, this.out.buffer);
        } else {
            while (srcIndex >= 0) {
                Decimal38SparseHolder.setInteger(dstIndex, intermediate[srcIndex], this.out.start, this.out.buffer);
                --srcIndex;
                --dstIndex;
            }
        }
    }
}

