/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL38DENSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal28DenseDecimal38Dense
implements DrillSimpleFunc {
    @Param
    Decimal28DenseHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal38DenseHolder out;

    public void setup() {
        int size = 16;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        boolean sign = Decimal28DenseHolder.getSign(this.in.start, this.in.buffer);
        for (int i = 0; i < 4; ++i) {
            Decimal38DenseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        int inputIdx = 3 - 1;
        int outputIdx = 4 - 1;
        while (inputIdx >= 0) {
            Decimal38DenseHolder.setInteger(outputIdx, Decimal28DenseHolder.getInteger(inputIdx, this.in.start, this.in.buffer), this.out.start, this.out.buffer);
            --inputIdx;
            --outputIdx;
        }
        if (this.in.scale != this.out.scale) {
            DecimalUtility.roundDecimal((DrillBuf)this.out.buffer, (int)this.out.start, (int)4, (int)this.out.scale, (int)this.in.scale);
        }
        Decimal38DenseHolder.setSign(sign, this.out.start, this.out.buffer);
    }
}

