/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal18VarChar
implements DrillSimpleFunc {
    @Param
    Decimal18Holder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded(20);
    }

    public void eval() {
        StringBuilder str = new StringBuilder();
        if (this.in.value < 0L) {
            str.append("-");
            this.in.value *= -1L;
        }
        long separator = DecimalUtility.getPowerOfTen((int)this.in.scale);
        str.append(this.in.value / separator);
        if (this.in.scale > 0) {
            str.append(".");
            String fractionalPart = String.valueOf(this.in.value % separator);
            str.append((CharSequence)DecimalUtility.toStringWithZeroes((long)(this.in.value % separator), (int)this.in.scale));
        }
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, String.valueOf(str.substring(0, this.out.end)).getBytes());
    }
}

