/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL9", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal18Decimal9
implements DrillSimpleFunc {
    @Param
    Decimal18Holder in;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal9Holder out;

    public void setup() {
    }

    public void eval() {
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        this.out.value = (int)this.in.value;
        if (this.out.scale > this.in.scale) {
            this.out.value *= (int)DecimalUtility.getPowerOfTen((int)(this.out.scale - this.in.scale));
        } else if (this.out.scale < this.in.scale) {
            int scaleFactor = (int)DecimalUtility.getPowerOfTen((int)this.in.scale);
            int newScaleFactor = (int)DecimalUtility.getPowerOfTen((int)((int)this.scale.value));
            int truncScaleFactor = (int)DecimalUtility.getPowerOfTen((int)((int)Math.abs((long)this.in.scale - this.scale.value)));
            int truncFactor = (int)((long)this.in.scale - this.scale.value);
            this.out.value = (int)(this.in.value / (long)scaleFactor);
            int fractionalPart = (int)(this.in.value % (long)scaleFactor);
            int newFractionalPart = (int)DecimalUtility.adjustScaleDivide((long)fractionalPart, (int)truncFactor);
            int truncatedFraction = fractionalPart % truncScaleFactor;
            int digit = Math.abs((int)DecimalUtility.adjustScaleDivide((long)truncatedFraction, (int)(truncFactor - 1)));
            if (digit > 4) {
                if (this.in.value > 0L) {
                    ++newFractionalPart;
                } else if (this.in.value < 0L) {
                    --newFractionalPart;
                }
            }
            this.out.value = this.out.value * newScaleFactor + newFractionalPart;
        }
    }
}

