/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL28SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal18Decimal28Sparse
implements DrillSimpleFunc {
    @Param
    Decimal18Holder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal28SparseHolder out;

    public void setup() {
        int size = 20;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        this.out.buffer = this.buffer;
        this.out.start = 0;
        for (int i = 0; i < 5; ++i) {
            Decimal28SparseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        this.out.buffer = this.buffer;
        this.out.start = 0;
        long value = this.in.value < 0L ? this.in.value * -1L : this.in.value;
        int index = 5 - 1;
        int remainingScale = this.in.scale;
        while (remainingScale > 0) {
            int power = remainingScale % 9;
            int padding = 1;
            if (power == 0) {
                power = 9;
            } else {
                padding = (int)DecimalUtility.getPowerOfTen((int)(9 - power));
            }
            int mask = (int)DecimalUtility.getPowerOfTen((int)power);
            Decimal28SparseHolder.setInteger(index, (int)(value % (long)mask * (long)padding), this.out.start, this.out.buffer);
            value /= (long)mask;
            remainingScale -= power;
            --index;
        }
        while (value > 0L) {
            Decimal28SparseHolder.setInteger(index, (int)(value % 1000000000L), this.out.start, this.out.buffer);
            value /= 1000000000L;
            --index;
        }
        if (this.in.scale != this.out.scale) {
            DecimalUtility.roundDecimal((DrillBuf)this.out.buffer, (int)this.out.start, (int)5, (int)this.out.scale, (int)this.in.scale);
        }
        Decimal28SparseHolder.setSign(this.in.value < 0L, this.out.start, this.out.buffer);
    }
}

