/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;

@FunctionTemplate(name="castDECIMAL28DENSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal18Decimal28Dense
implements DrillSimpleFunc {
    @Param
    Decimal18Holder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal28DenseHolder out;

    public void setup() {
        int size = 12;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        this.out.buffer = this.buffer;
        this.out.start = 0;
        for (int i = 0; i < 3; ++i) {
            Decimal28DenseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        this.out.buffer = this.buffer;
        this.out.start = 0;
        Decimal28DenseHolder.setSign(this.in.value < 0L, this.out.start, this.out.buffer);
        long value = this.in.value < 0L ? this.in.value * -1L : this.in.value;
        int index = 3 - 1;
        while (value > 0L) {
            Decimal28DenseHolder.setInteger(index, (int)(value % 1000000000L), this.out.start, this.out.buffer);
            value /= 1000000000L;
            --index;
        }
        int[] mask = new int[]{3, 15, 63, 255};
        int maskIndex = 0;
        int shiftOrder = 2;
        int byteIndex = 8 - 5;
        while (byteIndex >= 0) {
            byte shiftBits = (byte)((this.out.buffer.getByte(byteIndex) & mask[maskIndex]) << 8 - shiftOrder);
            int shiftOrder1 = byteIndex % 4 == 0 ? shiftOrder - 2 : shiftOrder;
            this.out.buffer.setByte(byteIndex + 1, (byte)((this.out.buffer.getByte(byteIndex + 1) & 0xFF) >>> shiftOrder1 | shiftBits));
            if (--byteIndex % 4 != 0) continue;
            shiftOrder += 2;
            ++maskIndex;
        }
    }
}

