/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castBIGINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastDecimal18BigInt
implements DrillSimpleFunc {
    @Param
    Decimal18Holder in;
    @Output
    BigIntHolder out;

    public void setup() {
    }

    public void eval() {
        int carry = DecimalUtility.getFirstFractionalDigit((long)this.in.value, (int)this.in.scale) > 4 ? 1 : 0;
        this.out.value = Math.abs(DecimalUtility.adjustScaleDivide((long)this.in.value, (int)this.in.scale)) + (long)carry;
        if (this.in.value < 0L) {
            this.out.value *= -1L;
        }
    }
}

