/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastBigIntVarChar
implements DrillSimpleFunc {
    @Param
    BigIntHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
    }

    public void eval() {
        this.buffer = this.buffer.reallocIfNeeded((int)this.len.value);
        String istr = new Long(this.in.value).toString();
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, istr.length());
        this.out.buffer.setBytes(0, istr.substring(0, this.out.end).getBytes());
    }
}

