/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL38SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastBigIntDecimal38Sparse
implements DrillSimpleFunc {
    @Param
    BigIntHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal38SparseHolder out;

    public void setup() {
        int size = 24;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        this.out.start = 0;
        this.out.buffer = this.buffer;
        for (int i = 0; i < 6; ++i) {
            Decimal38SparseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        if (this.in.value < 0L) {
            Decimal38SparseHolder.setSign(true, this.out.start, this.out.buffer);
        }
        int scaleSize = DecimalUtility.roundUp((int)((int)this.scale.value));
        int integerIndex = 6 - scaleSize - 1;
        for (long inValue = this.in.value; inValue != 0L && integerIndex >= 0; inValue /= 1000000000L) {
            Decimal38SparseHolder.setInteger(integerIndex--, (int)Math.abs(inValue % 1000000000L), this.out.start, this.out.buffer);
        }
    }
}

