/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariancePopFunctions {
    static final Logger logger = LoggerFactory.getLogger(VariancePopFunctions.class);

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8VariancePop
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += (this.in.value - temp) / (double)this.count.value;
                this.dev.value += (this.in.value - temp) * (this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8VariancePop
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += (this.in.value - temp) / (double)this.count.value;
            this.dev.value += (this.in.value - temp) * (this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4VariancePop
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4VariancePop
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt8VariancePop
    implements DrillAggFunc {
        @Param
        NullableUInt8Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt8VariancePop
    implements DrillAggFunc {
        @Param
        UInt8Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt4VariancePop
    implements DrillAggFunc {
        @Param
        NullableUInt4Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt4VariancePop
    implements DrillAggFunc {
        @Param
        UInt4Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt2VariancePop
    implements DrillAggFunc {
        @Param
        NullableUInt2Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt2VariancePop
    implements DrillAggFunc {
        @Param
        UInt2Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt1VariancePop
    implements DrillAggFunc {
        @Param
        NullableUInt1Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt1VariancePop
    implements DrillAggFunc {
        @Param
        UInt1Holder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTinyIntVariancePop
    implements DrillAggFunc {
        @Param
        NullableTinyIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TinyIntVariancePop
    implements DrillAggFunc {
        @Param
        TinyIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableSmallIntVariancePop
    implements DrillAggFunc {
        @Param
        NullableSmallIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class SmallIntVariancePop
    implements DrillAggFunc {
        @Param
        SmallIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntVariancePop
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntVariancePop
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntVariancePop
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                double temp = this.avg.value;
                this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
                this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
                ++this.count.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }

    @FunctionTemplate(name="var_pop", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntVariancePop
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        Float8Holder avg;
        @Workspace
        Float8Holder dev;
        @Workspace
        BigIntHolder count;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableFloat8Holder out;

        public void setup() {
            this.avg = new Float8Holder();
            this.dev = new Float8Holder();
            this.count = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            double temp = this.avg.value;
            this.avg.value += ((double)this.in.value - temp) / (double)this.count.value;
            this.dev.value += ((double)this.in.value - temp) * ((double)this.in.value - this.avg.value);
            ++this.count.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                if (this.count.value > 1L) {
                    this.out.value = this.dev.value / (double)(this.count.value - 1L);
                }
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.avg.value = 0.0;
            this.dev.value = 0.0;
            this.count.value = 1L;
        }
    }
}

