/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumZeroFunctions {
    static final Logger logger = LoggerFactory.getLogger(SumZeroFunctions.class);

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat8SumZero
    implements DrillAggFunc {
        @Param
        NullableFloat8Holder in;
        @Workspace
        Float8Holder value;
        @Output
        Float8Holder out;

        public void setup() {
            this.value.value = 0.0;
        }

        public void add() {
            this.value.value += this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableFloat4SumZero
    implements DrillAggFunc {
        @Param
        NullableFloat4Holder in;
        @Workspace
        Float8Holder value;
        @Output
        Float8Holder out;

        public void setup() {
            this.value.value = 0.0;
        }

        public void add() {
            this.value.value += (double)this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float8SumZero
    implements DrillAggFunc {
        @Param
        Float8Holder in;
        @Workspace
        Float8Holder value;
        @Output
        Float8Holder out;

        public void setup() {
            this.value.value = 0.0;
        }

        public void add() {
            this.value.value += this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class Float4SumZero
    implements DrillAggFunc {
        @Param
        Float4Holder in;
        @Workspace
        Float8Holder value;
        @Output
        Float8Holder out;

        public void setup() {
            this.value.value = 0.0;
        }

        public void add() {
            this.value.value += (double)this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0.0;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntSumZero
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Output
        BigIntHolder out;

        public void setup() {
            this.value.value = 0L;
        }

        public void add() {
            this.value.value += this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntSumZero
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        BigIntHolder value;
        @Output
        BigIntHolder out;

        public void setup() {
            this.value.value = 0L;
        }

        public void add() {
            this.value.value += (long)this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBitSumZero
    implements DrillAggFunc {
        @Param
        NullableBitHolder in;
        @Workspace
        BitHolder value;
        @Output
        BitHolder out;

        public void setup() {
            this.value.value = 0;
        }

        public void add() {
            this.value.value += this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntSumZero
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        BigIntHolder value;
        @Output
        BigIntHolder out;

        public void setup() {
            this.value.value = 0L;
        }

        public void add() {
            this.value.value += this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntSumZero
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        BigIntHolder value;
        @Output
        BigIntHolder out;

        public void setup() {
            this.value.value = 0L;
        }

        public void add() {
            this.value.value += (long)this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0L;
        }
    }

    @FunctionTemplate(name="$sum0", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BitSumZero
    implements DrillAggFunc {
        @Param
        BitHolder in;
        @Workspace
        BitHolder value;
        @Output
        BitHolder out;

        public void setup() {
            this.value.value = 0;
        }

        public void add() {
            this.value.value += this.in.value;
        }

        public void output() {
            this.out.value = this.value.value;
        }

        public void reset() {
            this.value.value = 0;
        }
    }
}

