/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;

public class SumDateTypeFunctions {

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalSum
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        IntervalHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        public void setup() {
            this.value = new IntervalHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.months = 0;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.days += this.in.days;
                this.value.months += this.in.months;
                this.value.milliseconds += this.in.milliseconds;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.months = this.value.months;
                this.out.days = this.value.days;
                this.out.milliseconds = this.value.milliseconds;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.months = 0;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalSum
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        IntervalHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        public void setup() {
            this.value = new IntervalHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.months = 0;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.days += this.in.days;
            this.value.months += this.in.months;
            this.value.milliseconds += this.in.milliseconds;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.months = this.value.months;
                this.out.days = this.value.days;
                this.out.milliseconds = this.value.milliseconds;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.months = 0;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalYearSum
    implements DrillAggFunc {
        @Param
        NullableIntervalYearHolder in;
        @Workspace
        IntervalYearHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalYearHolder out;

        public void setup() {
            this.value = new IntervalYearHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value += this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalYearSum
    implements DrillAggFunc {
        @Param
        IntervalYearHolder in;
        @Workspace
        IntervalYearHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalYearHolder out;

        public void setup() {
            this.value = new IntervalYearHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value += this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = 0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalDaySum
    implements DrillAggFunc {
        @Param
        NullableIntervalDayHolder in;
        @Workspace
        IntervalDayHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalDayHolder out;

        public void setup() {
            this.value = new IntervalDayHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.days += this.in.days;
                this.value.milliseconds += this.in.milliseconds;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.days = this.value.days;
                this.out.milliseconds = this.value.milliseconds;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalDaySum
    implements DrillAggFunc {
        @Param
        IntervalDayHolder in;
        @Workspace
        IntervalDayHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalDayHolder out;

        public void setup() {
            this.value = new IntervalDayHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.days += this.in.days;
            this.value.milliseconds += this.in.milliseconds;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.days = this.value.days;
                this.out.milliseconds = this.value.milliseconds;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.days = 0;
            this.value.milliseconds = 0;
        }
    }
}

