/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;

public class MaxDateTypeFunctions {

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalMax
    implements DrillAggFunc {
        @Param
        NullableIntervalHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                long inMS = (long)this.in.months * 2592000000L + (long)(this.in.days * 86400000) + (long)this.in.milliseconds;
                this.value.value = Math.max(this.value.value, inMS);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.months = (int)(this.value.value / 2592000000L);
                this.value.value %= 2592000000L;
                this.out.days = (int)(this.value.value / 86400000L);
                this.out.milliseconds = (int)(this.value.value % 86400000L);
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalMax
    implements DrillAggFunc {
        @Param
        IntervalHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalHolder out;

        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            long inMS = (long)this.in.months * 2592000000L + (long)(this.in.days * 86400000) + (long)this.in.milliseconds;
            this.value.value = Math.max(this.value.value, inMS);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.months = (int)(this.value.value / 2592000000L);
                this.value.value %= 2592000000L;
                this.out.days = (int)(this.value.value / 86400000L);
                this.out.milliseconds = (int)(this.value.value % 86400000L);
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalYearMax
    implements DrillAggFunc {
        @Param
        NullableIntervalYearHolder in;
        @Workspace
        IntervalYearHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalYearHolder out;

        public void setup() {
            this.value = new IntervalYearHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalYearMax
    implements DrillAggFunc {
        @Param
        IntervalYearHolder in;
        @Workspace
        IntervalYearHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalYearHolder out;

        public void setup() {
            this.value = new IntervalYearHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntervalDayMax
    implements DrillAggFunc {
        @Param
        NullableIntervalDayHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalDayHolder out;

        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                long inMS = (long)this.in.days * 86400000L + (long)this.in.milliseconds;
                this.value.value = Math.max(this.value.value, inMS);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.days = (int)(this.value.value / 86400000L);
                this.out.milliseconds = (int)(this.value.value % 86400000L);
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntervalDayMax
    implements DrillAggFunc {
        @Param
        IntervalDayHolder in;
        @Workspace
        BigIntHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntervalDayHolder out;

        public void setup() {
            this.value = new BigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            long inMS = (long)this.in.days * 86400000L + (long)this.in.milliseconds;
            this.value.value = Math.max(this.value.value, inMS);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.days = (int)(this.value.value / 86400000L);
                this.out.milliseconds = (int)(this.value.value % 86400000L);
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeMax
    implements DrillAggFunc {
        @Param
        NullableTimeHolder in;
        @Workspace
        TimeHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableTimeHolder out;

        public void setup() {
            this.value = new TimeHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeMax
    implements DrillAggFunc {
        @Param
        TimeHolder in;
        @Workspace
        TimeHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableTimeHolder out;

        public void setup() {
            this.value = new TimeHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTimeStampMax
    implements DrillAggFunc {
        @Param
        NullableTimeStampHolder in;
        @Workspace
        TimeStampHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableTimeStampHolder out;

        public void setup() {
            this.value = new TimeStampHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TimeStampMax
    implements DrillAggFunc {
        @Param
        TimeStampHolder in;
        @Workspace
        TimeStampHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableTimeStampHolder out;

        public void setup() {
            this.value = new TimeStampHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableDateMax
    implements DrillAggFunc {
        @Param
        NullableDateHolder in;
        @Workspace
        DateHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableDateHolder out;

        public void setup() {
            this.value = new DateHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.value.value = Math.max(this.value.value, this.in.value);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="max", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class DateMax
    implements DrillAggFunc {
        @Param
        DateHolder in;
        @Workspace
        DateHolder value;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableDateHolder out;

        public void setup() {
            this.value = new DateHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.value.value = Math.max(this.value.value, this.in.value);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.value.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.value.value = Long.MIN_VALUE;
        }
    }
}

