/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.gaggr.SumFunctions;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.util.DecimalUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalSumFunctions {
    static final Logger logger = LoggerFactory.getLogger(SumFunctions.class);

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class NullableDecimal38SparseSum
    implements DrillAggFunc {
        @Param
        NullableDecimal38SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                BigDecimal currentValue = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.in.buffer, (int)this.in.start, (int)6, (int)this.in.scale);
                this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
                if (this.outputScale.value == Integer.MIN_VALUE) {
                    this.outputScale.value = this.in.scale;
                }
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class Decimal38SparseSum
    implements DrillAggFunc {
        @Param
        Decimal38SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            BigDecimal currentValue = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.in.buffer, (int)this.in.start, (int)6, (int)this.in.scale);
            this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
            if (this.outputScale.value == Integer.MIN_VALUE) {
                this.outputScale.value = this.in.scale;
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class NullableDecimal28SparseSum
    implements DrillAggFunc {
        @Param
        NullableDecimal28SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                BigDecimal currentValue = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.in.buffer, (int)this.in.start, (int)5, (int)this.in.scale);
                this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
                if (this.outputScale.value == Integer.MIN_VALUE) {
                    this.outputScale.value = this.in.scale;
                }
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class Decimal28SparseSum
    implements DrillAggFunc {
        @Param
        Decimal28SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            BigDecimal currentValue = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.in.buffer, (int)this.in.start, (int)5, (int)this.in.scale);
            this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
            if (this.outputScale.value == Integer.MIN_VALUE) {
                this.outputScale.value = this.in.scale;
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class NullableDecimal18Sum
    implements DrillAggFunc {
        @Param
        NullableDecimal18Holder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                BigDecimal currentValue = DecimalUtility.getBigDecimalFromPrimitiveTypes((long)this.in.value, (int)this.in.scale, (int)this.in.precision);
                this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
                if (this.outputScale.value == Integer.MIN_VALUE) {
                    this.outputScale.value = this.in.scale;
                }
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class Decimal18Sum
    implements DrillAggFunc {
        @Param
        Decimal18Holder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            BigDecimal currentValue = DecimalUtility.getBigDecimalFromPrimitiveTypes((long)this.in.value, (int)this.in.scale, (int)this.in.precision);
            this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
            if (this.outputScale.value == Integer.MIN_VALUE) {
                this.outputScale.value = this.in.scale;
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class NullableDecimal9Sum
    implements DrillAggFunc {
        @Param
        NullableDecimal9Holder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                BigDecimal currentValue = DecimalUtility.getBigDecimalFromPrimitiveTypes((int)this.in.value, (int)this.in.scale, (int)this.in.precision);
                this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
                if (this.outputScale.value == Integer.MIN_VALUE) {
                    this.outputScale.value = this.in.scale;
                }
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }

    @FunctionTemplate(name="sum", scope=FunctionTemplate.FunctionScope.DECIMAL_SUM_AGGREGATE)
    public static class Decimal9Sum
    implements DrillAggFunc {
        @Param
        Decimal9Holder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        ObjectHolder value;
        @Workspace
        IntHolder outputScale;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.buffer = this.buffer.reallocIfNeeded(24);
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }

        public void add() {
            BigDecimal currentValue = DecimalUtility.getBigDecimalFromPrimitiveTypes((int)this.in.value, (int)this.in.scale, (int)this.in.precision);
            this.value.obj = ((BigDecimal)this.value.obj).add(currentValue);
            if (this.outputScale.value == Integer.MIN_VALUE) {
                this.outputScale.value = this.in.scale;
            }
        }

        public void output() {
            this.out.buffer = this.buffer;
            this.out.start = 0;
            this.out.scale = this.outputScale.value;
            this.out.precision = 38;
            this.value.obj = ((BigDecimal)this.value.obj).setScale(this.out.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((BigDecimal)this.value.obj), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)6);
        }

        public void reset() {
            this.value = new ObjectHolder();
            this.value.obj = BigDecimal.ZERO;
            this.outputScale = new IntHolder();
            this.outputScale.value = Integer.MIN_VALUE;
        }
    }
}

