/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.gaggr.MinFunctions;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.ObjectHolder;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalMinFunctions {
    static final Logger logger = LoggerFactory.getLogger(MinFunctions.class);

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class NullableDecimal38SparseMin
    implements DrillAggFunc {
        @Param
        NullableDecimal38SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Workspace
        ObjectHolder value;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.value = new ObjectHolder();
            byte[] byteArray = new byte[24];
            Text tmp = new Text(byteArray);
            this.value.obj = tmp;
            for (int i = 0; i < 6; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Integer.MAX_VALUE);
            }
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }

        public void add() {
            Text tmp;
            int cmp;
            if (this.in.isSet != 0 && (cmp = DecimalUtility.compareSparseSamePrecScale((DrillBuf)this.in.buffer, (int)this.in.start, (byte[])(tmp = (Text)this.value.obj).getBytes(), (int)tmp.getLength())) == -1) {
                for (int i = 0; i < 6; ++i) {
                    ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Decimal38SparseHolder.getInteger(i, this.in.start, this.in.buffer));
                }
                ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)NullableDecimal38SparseHolder.getSign(this.in.start, this.in.buffer));
                this.scale.value = this.in.scale;
                this.precision.value = this.in.precision;
            }
        }

        public void output() {
            Text tmp = (Text)this.value.obj;
            this.buffer = this.buffer.reallocIfNeeded(tmp.getLength());
            for (int i = 0; i < 6; ++i) {
                Decimal38SparseHolder.setInteger(i, ByteFunctionHelpers.getInteger((byte[])tmp.getBytes(), (int)i), 0, this.buffer);
            }
            this.out.buffer = this.buffer;
            this.out.start = 0;
            Decimal38SparseHolder.setSign(ByteFunctionHelpers.getSign((byte[])tmp.getBytes()), this.out.start, this.out.buffer);
            this.out.scale = this.scale.value;
            this.out.precision = this.precision.value;
        }

        public void reset() {
            Text tmp = (Text)this.value.obj;
            for (int i = 0; i < 6; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)-1);
            }
            this.scale.value = 0;
            this.precision.value = 0;
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class Decimal38SparseMin
    implements DrillAggFunc {
        @Param
        Decimal38SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Workspace
        ObjectHolder value;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.value = new ObjectHolder();
            byte[] byteArray = new byte[24];
            Text tmp = new Text(byteArray);
            this.value.obj = tmp;
            for (int i = 0; i < 6; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Integer.MAX_VALUE);
            }
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }

        public void add() {
            Text tmp = (Text)this.value.obj;
            int cmp = DecimalUtility.compareSparseSamePrecScale((DrillBuf)this.in.buffer, (int)this.in.start, (byte[])tmp.getBytes(), (int)tmp.getLength());
            if (cmp == -1) {
                for (int i = 0; i < 6; ++i) {
                    ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Decimal38SparseHolder.getInteger(i, this.in.start, this.in.buffer));
                }
                ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)Decimal38SparseHolder.getSign(this.in.start, this.in.buffer));
                this.scale.value = this.in.scale;
                this.precision.value = this.in.precision;
            }
        }

        public void output() {
            Text tmp = (Text)this.value.obj;
            this.buffer = this.buffer.reallocIfNeeded(tmp.getLength());
            for (int i = 0; i < 6; ++i) {
                Decimal38SparseHolder.setInteger(i, ByteFunctionHelpers.getInteger((byte[])tmp.getBytes(), (int)i), 0, this.buffer);
            }
            this.out.buffer = this.buffer;
            this.out.start = 0;
            Decimal38SparseHolder.setSign(ByteFunctionHelpers.getSign((byte[])tmp.getBytes()), this.out.start, this.out.buffer);
            this.out.scale = this.scale.value;
            this.out.precision = this.precision.value;
        }

        public void reset() {
            Text tmp = (Text)this.value.obj;
            for (int i = 0; i < 6; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)-1);
            }
            this.scale.value = 0;
            this.precision.value = 0;
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class NullableDecimal28SparseMin
    implements DrillAggFunc {
        @Param
        NullableDecimal28SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Workspace
        ObjectHolder value;
        @Output
        Decimal28SparseHolder out;

        public void setup() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.value = new ObjectHolder();
            byte[] byteArray = new byte[20];
            Text tmp = new Text(byteArray);
            this.value.obj = tmp;
            for (int i = 0; i < 5; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Integer.MAX_VALUE);
            }
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }

        public void add() {
            Text tmp;
            int cmp;
            if (this.in.isSet != 0 && (cmp = DecimalUtility.compareSparseSamePrecScale((DrillBuf)this.in.buffer, (int)this.in.start, (byte[])(tmp = (Text)this.value.obj).getBytes(), (int)tmp.getLength())) == -1) {
                for (int i = 0; i < 5; ++i) {
                    ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Decimal28SparseHolder.getInteger(i, this.in.start, this.in.buffer));
                }
                ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)NullableDecimal28SparseHolder.getSign(this.in.start, this.in.buffer));
                this.scale.value = this.in.scale;
                this.precision.value = this.in.precision;
            }
        }

        public void output() {
            Text tmp = (Text)this.value.obj;
            this.buffer = this.buffer.reallocIfNeeded(tmp.getLength());
            for (int i = 0; i < 5; ++i) {
                Decimal28SparseHolder.setInteger(i, ByteFunctionHelpers.getInteger((byte[])tmp.getBytes(), (int)i), 0, this.buffer);
            }
            this.out.buffer = this.buffer;
            this.out.start = 0;
            Decimal28SparseHolder.setSign(ByteFunctionHelpers.getSign((byte[])tmp.getBytes()), this.out.start, this.out.buffer);
            this.out.scale = this.scale.value;
            this.out.precision = this.precision.value;
        }

        public void reset() {
            Text tmp = (Text)this.value.obj;
            for (int i = 0; i < 5; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)-1);
            }
            this.scale.value = 0;
            this.precision.value = 0;
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class Decimal28SparseMin
    implements DrillAggFunc {
        @Param
        Decimal28SparseHolder in;
        @Inject
        DrillBuf buffer;
        @Workspace
        IntHolder scale;
        @Workspace
        IntHolder precision;
        @Workspace
        ObjectHolder value;
        @Output
        Decimal28SparseHolder out;

        public void setup() {
            this.scale.value = 0;
            this.precision.value = 0;
            this.value = new ObjectHolder();
            byte[] byteArray = new byte[20];
            Text tmp = new Text(byteArray);
            this.value.obj = tmp;
            for (int i = 0; i < 5; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Integer.MAX_VALUE);
            }
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }

        public void add() {
            Text tmp = (Text)this.value.obj;
            int cmp = DecimalUtility.compareSparseSamePrecScale((DrillBuf)this.in.buffer, (int)this.in.start, (byte[])tmp.getBytes(), (int)tmp.getLength());
            if (cmp == -1) {
                for (int i = 0; i < 5; ++i) {
                    ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)Decimal28SparseHolder.getInteger(i, this.in.start, this.in.buffer));
                }
                ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)Decimal28SparseHolder.getSign(this.in.start, this.in.buffer));
                this.scale.value = this.in.scale;
                this.precision.value = this.in.precision;
            }
        }

        public void output() {
            Text tmp = (Text)this.value.obj;
            this.buffer = this.buffer.reallocIfNeeded(tmp.getLength());
            for (int i = 0; i < 5; ++i) {
                Decimal28SparseHolder.setInteger(i, ByteFunctionHelpers.getInteger((byte[])tmp.getBytes(), (int)i), 0, this.buffer);
            }
            this.out.buffer = this.buffer;
            this.out.start = 0;
            Decimal28SparseHolder.setSign(ByteFunctionHelpers.getSign((byte[])tmp.getBytes()), this.out.start, this.out.buffer);
            this.out.scale = this.scale.value;
            this.out.precision = this.precision.value;
        }

        public void reset() {
            Text tmp = (Text)this.value.obj;
            for (int i = 0; i < 5; ++i) {
                ByteFunctionHelpers.setInteger((byte[])tmp.getBytes(), (int)i, (int)-1);
            }
            this.scale.value = 0;
            this.precision.value = 0;
            ByteFunctionHelpers.setSign((byte[])tmp.getBytes(), (boolean)false);
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class NullableDecimal18Min
    implements DrillAggFunc {
        @Param
        NullableDecimal18Holder in;
        @Workspace
        Decimal18Holder value;
        @Output
        Decimal18Holder out;

        public void setup() {
            this.value = new Decimal18Holder();
            this.value.value = Integer.MAX_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.value.value = Math.min(this.value.value, this.in.value);
            }
        }

        public void output() {
            this.out.value = this.value.value;
            this.out.scale = this.value.scale;
            this.out.precision = this.value.precision;
        }

        public void reset() {
            this.value = new Decimal18Holder();
            this.value.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class Decimal18Min
    implements DrillAggFunc {
        @Param
        Decimal18Holder in;
        @Workspace
        Decimal18Holder value;
        @Output
        Decimal18Holder out;

        public void setup() {
            this.value = new Decimal18Holder();
            this.value.value = Integer.MAX_VALUE;
        }

        public void add() {
            this.value.value = Math.min(this.value.value, this.in.value);
        }

        public void output() {
            this.out.value = this.value.value;
            this.out.scale = this.value.scale;
            this.out.precision = this.value.precision;
        }

        public void reset() {
            this.value = new Decimal18Holder();
            this.value.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class NullableDecimal9Min
    implements DrillAggFunc {
        @Param
        NullableDecimal9Holder in;
        @Workspace
        Decimal9Holder value;
        @Output
        Decimal9Holder out;

        public void setup() {
            this.value = new Decimal9Holder();
            this.value.value = Integer.MAX_VALUE;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.value.value = Math.min(this.value.value, this.in.value);
            }
        }

        public void output() {
            this.out.value = this.value.value;
            this.out.scale = this.value.scale;
            this.out.precision = this.value.precision;
        }

        public void reset() {
            this.value = new Decimal9Holder();
            this.value.value = Integer.MAX_VALUE;
        }
    }

    @FunctionTemplate(name="min", scope=FunctionTemplate.FunctionScope.DECIMAL_AGGREGATE)
    public static class Decimal9Min
    implements DrillAggFunc {
        @Param
        Decimal9Holder in;
        @Workspace
        Decimal9Holder value;
        @Output
        Decimal9Holder out;

        public void setup() {
            this.value = new Decimal9Holder();
            this.value.value = Integer.MAX_VALUE;
        }

        public void add() {
            this.value.value = Math.min(this.value.value, this.in.value);
        }

        public void output() {
            this.out.value = this.value.value;
            this.out.scale = this.value.scale;
            this.out.precision = this.value.precision;
        }

        public void reset() {
            this.value = new Decimal9Holder();
            this.value.value = Integer.MAX_VALUE;
        }
    }
}

