/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitwiseOrFunctions {
    static final Logger logger = LoggerFactory.getLogger(BitwiseOrFunctions.class);

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt8BitwiseOr
    implements DrillAggFunc {
        @Param
        NullableUInt8Holder in;
        @Workspace
        NullableUInt8Holder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableUInt8Holder out;

        public void setup() {
            this.inter = new NullableUInt8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value |= this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt8BitwiseOr
    implements DrillAggFunc {
        @Param
        UInt8Holder in;
        @Workspace
        NullableUInt8Holder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableUInt8Holder out;

        public void setup() {
            this.inter = new NullableUInt8Holder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value |= this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt4BitwiseOr
    implements DrillAggFunc {
        @Param
        NullableUInt4Holder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value |= this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt4BitwiseOr
    implements DrillAggFunc {
        @Param
        UInt4Holder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value |= this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt2BitwiseOr
    implements DrillAggFunc {
        @Param
        NullableUInt2Holder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value |= this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt2BitwiseOr
    implements DrillAggFunc {
        @Param
        UInt2Holder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value |= this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableUInt1BitwiseOr
    implements DrillAggFunc {
        @Param
        NullableUInt1Holder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value |= this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class UInt1BitwiseOr
    implements DrillAggFunc {
        @Param
        UInt1Holder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value |= this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableTinyIntBitwiseOr
    implements DrillAggFunc {
        @Param
        NullableTinyIntHolder in;
        @Workspace
        NullableTinyIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableTinyIntHolder out;

        public void setup() {
            this.inter = new NullableTinyIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value = (byte)(this.inter.value | this.in.value);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class TinyIntBitwiseOr
    implements DrillAggFunc {
        @Param
        TinyIntHolder in;
        @Workspace
        NullableTinyIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableTinyIntHolder out;

        public void setup() {
            this.inter = new NullableTinyIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value = (byte)(this.inter.value | this.in.value);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableSmallIntBitwiseOr
    implements DrillAggFunc {
        @Param
        NullableSmallIntHolder in;
        @Workspace
        NullableSmallIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableSmallIntHolder out;

        public void setup() {
            this.inter = new NullableSmallIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value = (short)(this.inter.value | this.in.value);
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class SmallIntBitwiseOr
    implements DrillAggFunc {
        @Param
        SmallIntHolder in;
        @Workspace
        NullableSmallIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableSmallIntHolder out;

        public void setup() {
            this.inter = new NullableSmallIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value = (short)(this.inter.value | this.in.value);
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableIntBitwiseOr
    implements DrillAggFunc {
        @Param
        NullableIntHolder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value |= this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class IntBitwiseOr
    implements DrillAggFunc {
        @Param
        IntHolder in;
        @Workspace
        NullableIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableIntHolder out;

        public void setup() {
            this.inter = new NullableIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value |= this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class NullableBigIntBitwiseOr
    implements DrillAggFunc {
        @Param
        NullableBigIntHolder in;
        @Workspace
        NullableBigIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        public void setup() {
            this.inter = new NullableBigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }

        public void add() {
            if (this.in.isSet != 0) {
                this.nonNullCount.value = 1L;
                this.inter.value |= this.in.value;
            }
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }
    }

    @FunctionTemplate(name="bit_or", scope=FunctionTemplate.FunctionScope.POINT_AGGREGATE)
    public static class BigIntBitwiseOr
    implements DrillAggFunc {
        @Param
        BigIntHolder in;
        @Workspace
        NullableBigIntHolder inter;
        @Workspace
        BigIntHolder nonNullCount;
        @Output
        NullableBigIntHolder out;

        public void setup() {
            this.inter = new NullableBigIntHolder();
            this.nonNullCount = new BigIntHolder();
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }

        public void add() {
            this.nonNullCount.value = 1L;
            this.inter.value |= this.in.value;
        }

        public void output() {
            if (this.nonNullCount.value > 0L) {
                this.out.isSet = 1;
                this.out.value = this.inter.value;
            } else {
                this.out.isSet = 0;
            }
        }

        public void reset() {
            this.nonNullCount.value = 0L;
            this.inter.value = 0L;
        }
    }
}

