/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;

public class IntervalYearIntFunctions {

    @FunctionTemplate(names={"divide", "div"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearIntDivideFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Param
        IntHolder right;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            double fractionalMonths = 0.0;
            double fractionalDays = 0.0;
            double fractionalMillis = 0.0;
            fractionalMonths = (double)this.left.value / (double)this.right.value;
            this.out.months = (int)fractionalMonths;
            fractionalMonths -= (double)((long)fractionalMonths);
            this.out.days = (int)(fractionalDays += fractionalMonths * 30.0);
            fractionalDays -= (double)((long)fractionalDays);
            this.out.milliseconds = (int)(fractionalMillis += fractionalDays * 8.64E7);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntIntervalYearMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntHolder right;
        @Param
        IntervalYearHolder left;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.months = this.left.value * this.right.value;
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearIntMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Param
        IntHolder right;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.months = this.left.value * this.right.value;
        }
    }
}

