/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;

public class IntervalYearFunctions {

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearNegateFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Output
        IntervalYearHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = -this.left.value;
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearSubtractFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value - this.right.value;
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder left;
        @Param
        IntervalYearHolder right;
        @Output
        IntervalYearHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value + this.right.value;
        }
    }
}

