/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;

public class IntervalIntFunctions {

    @FunctionTemplate(names={"divide", "div"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalIntDivideFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Param
        IntHolder right;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            double fractionalMonths = 0.0;
            double fractionalDays = 0.0;
            double fractionalMillis = 0.0;
            fractionalMonths = (double)this.left.months / (double)this.right.value;
            fractionalDays = (double)this.left.days / (double)this.right.value;
            fractionalMillis = (double)this.left.milliseconds / (double)this.right.value;
            this.out.months = (int)fractionalMonths;
            fractionalMonths -= (double)((long)fractionalMonths);
            this.out.days = (int)(fractionalDays += fractionalMonths * 30.0);
            fractionalDays -= (double)((long)fractionalDays);
            this.out.milliseconds = (int)(fractionalMillis += fractionalDays * 8.64E7);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntIntervalMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntHolder right;
        @Param
        IntervalHolder left;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.months = this.left.months * this.right.value;
            this.out.days = this.left.days * this.right.value;
            this.out.milliseconds = this.left.milliseconds * this.right.value;
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalIntMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Param
        IntHolder right;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.months = this.left.months * this.right.value;
            this.out.days = this.left.days * this.right.value;
            this.out.milliseconds = this.left.milliseconds * this.right.value;
        }
    }
}

