/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;

public class IntervalDayFunctions {

    @FunctionTemplate(names={"negative", "u-", "-"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayNegateFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Output
        IntervalDayHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.days = -this.left.days;
            this.out.milliseconds = -this.left.milliseconds;
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDaySubtractFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.days = this.left.days - this.right.days;
            this.out.milliseconds = this.left.milliseconds - this.right.milliseconds;
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalDayAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder left;
        @Param
        IntervalDayHolder right;
        @Output
        IntervalDayHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.days = this.left.days + this.right.days;
            this.out.milliseconds = this.left.milliseconds + this.right.milliseconds;
        }
    }
}

