/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;

public class IntervalBigIntFunctions {

    @FunctionTemplate(names={"divide", "div"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalBigIntDivideFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            double fractionalMonths = 0.0;
            double fractionalDays = 0.0;
            double fractionalMillis = 0.0;
            fractionalMonths = (double)this.left.months / (double)this.right.value;
            fractionalDays = (double)this.left.days / (double)this.right.value;
            fractionalMillis = (double)this.left.milliseconds / (double)this.right.value;
            this.out.months = (int)fractionalMonths;
            fractionalMonths -= (double)((long)fractionalMonths);
            this.out.days = (int)(fractionalDays += fractionalMonths * 30.0);
            fractionalDays -= (double)((long)fractionalDays);
            this.out.milliseconds = (int)(fractionalMillis += fractionalDays * 8.64E7);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BigIntIntervalMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        BigIntHolder right;
        @Param
        IntervalHolder left;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.months = (int)((long)this.left.months * this.right.value);
            this.out.days = (int)((long)this.left.days * this.right.value);
            this.out.milliseconds = (int)((long)this.left.milliseconds * this.right.value);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalBigIntMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        IntervalHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntervalHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.months = (int)((long)this.left.months * this.right.value);
            this.out.days = (int)((long)this.left.days * this.right.value);
            this.out.milliseconds = (int)((long)this.left.milliseconds * this.right.value);
        }
    }
}

