/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class GExtract {

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.value / 12;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.value % 12;
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromIntervalYear
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = 0.0;
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = 0L;
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.days;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.milliseconds / 3600000;
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            int millis = this.in.milliseconds % 3600000;
            this.out.value = millis / 60000;
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromIntervalDay
    implements DrillSimpleFunc {
        @Param
        IntervalDayHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            long millis = this.in.milliseconds % 60000;
            this.out.value = (double)millis / 1000.0;
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.months / 12;
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.months % 12;
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.days;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.milliseconds / 3600000;
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            int millis = this.in.milliseconds % 3600000;
            this.out.value = millis / 60000;
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromInterval
    implements DrillSimpleFunc {
        @Param
        IntervalHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            long millis = this.in.milliseconds % 60000;
            this.out.value = (double)millis / 1000.0;
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getYear();
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMonthOfYear();
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfMonth();
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getHourOfDay();
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMinuteOfHour();
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromTimeStamp
    implements DrillSimpleFunc {
        @Param
        TimeStampHolder in;
        @Output
        Float8Holder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getSecondOfMinute();
            this.out.value += (double)this.dateTime.getMillisOfSecond() / 1000.0;
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis((long)this.in.value);
            this.out.value = this.dateTime.getHourOfDay();
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis((long)this.in.value);
            this.out.value = this.dateTime.getMinuteOfHour();
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromTime
    implements DrillSimpleFunc {
        @Param
        TimeHolder in;
        @Output
        Float8Holder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis((long)this.in.value);
            this.out.value = this.dateTime.getSecondOfMinute();
            this.out.value += (double)this.dateTime.getMillisOfSecond() / 1000.0;
        }
    }

    @FunctionTemplate(name="extractYear", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class YearFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getYear();
        }
    }

    @FunctionTemplate(name="extractMonth", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MonthFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMonthOfYear();
        }
    }

    @FunctionTemplate(name="extractDay", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DayFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getDayOfMonth();
        }
    }

    @FunctionTemplate(name="extractHour", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class HourFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getHourOfDay();
        }
    }

    @FunctionTemplate(name="extractMinute", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class MinuteFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        BigIntHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getMinuteOfHour();
        }
    }

    @FunctionTemplate(name="extractSecond", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class SecondFromDate
    implements DrillSimpleFunc {
        @Param
        DateHolder in;
        @Output
        Float8Holder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.in.value);
            this.out.value = this.dateTime.getSecondOfMinute();
            this.out.value += (double)this.dateTime.getMillisOfSecond() / 1000.0;
        }
    }
}

