/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="to_char", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class GDecimal9ToChar
implements DrillSimpleFunc {
    @Param
    Decimal9Holder left;
    @Param
    VarCharHolder right;
    @Inject
    DrillBuf buffer;
    @Workspace
    NumberFormat outputFormat;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded(100);
        byte[] buf = new byte[this.right.end - this.right.start];
        this.right.buffer.getBytes(this.right.start, buf, 0, this.right.end - this.right.start);
        String inputFormat = new String(buf);
        this.outputFormat = new DecimalFormat(inputFormat);
    }

    public void eval() {
        BigDecimal bigDecimal = new BigDecimal(BigInteger.valueOf(this.left.value), this.left.scale);
        String str = this.outputFormat.format(bigDecimal);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min(100, str.length());
        this.out.buffer.setBytes(0, str.substring(0, this.out.end).getBytes());
    }
}

