/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@FunctionTemplate(name="to_timestamp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class GDecimal18ToTimeStamp
implements DrillSimpleFunc {
    @Param
    Decimal18Holder left;
    @Workspace
    BigInteger millisConstant;
    @Output
    TimeStampHolder out;

    public void setup() {
        this.millisConstant = BigInteger.valueOf(1000L);
    }

    public void eval() {
        long inputMillis = 0L;
        BigInteger value = BigInteger.valueOf(this.left.value);
        value = value.multiply(this.millisConstant);
        inputMillis = new BigDecimal(value, this.left.scale).longValue();
        this.out.value = new DateTime(inputMillis).withZoneRetainFields(DateTimeZone.UTC).getMillis();
    }
}

