/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class GDateTimeTruncateFunctions {

    @FunctionTemplate(names={"date_trunc"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        TimeHolder right;
        @Output
        TimeHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis((long)this.right.value);
            if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("HOUR")) {
                this.dateTime.setRounding(this.dateTime.getChronology().hourOfDay());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("MINUTE")) {
                this.dateTime.setRounding(this.dateTime.getChronology().minuteOfHour());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("SECOND")) {
                this.dateTime.setRounding(this.dateTime.getChronology().secondOfMinute());
            } else {
                throw new UnsupportedOperationException("date_trunc function supports the following time units for Time: HOUR, MINUTE, SECOND");
            }
            this.out.value = (int)this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GTimeStampDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        TimeStampHolder right;
        @Output
        TimeStampHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.right.value);
            if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("YEAR")) {
                this.dateTime.setRounding(this.dateTime.getChronology().year());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("MONTH")) {
                this.dateTime.setRounding(this.dateTime.getChronology().monthOfYear());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("DAY")) {
                this.dateTime.setRounding(this.dateTime.getChronology().dayOfMonth());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("HOUR")) {
                this.dateTime.setRounding(this.dateTime.getChronology().hourOfDay());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("MINUTE")) {
                this.dateTime.setRounding(this.dateTime.getChronology().minuteOfHour());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("SECOND")) {
                this.dateTime.setRounding(this.dateTime.getChronology().secondOfMinute());
            } else {
                throw new UnsupportedOperationException("date_trunc function supports the following time units for TimeStamp: YEAR, MONTH, DAY, HOUR, MINUTE, SECOND");
            }
            this.out.value = this.dateTime.getMillis();
        }
    }

    @FunctionTemplate(names={"date_trunc"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GDateDateTrunc
    implements DrillSimpleFunc {
        @Param
        VarCharHolder left;
        @Param
        DateHolder right;
        @Output
        DateHolder out;
        @Workspace
        MutableDateTime dateTime;

        public void setup() {
            this.dateTime = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.dateTime.setMillis(this.right.value);
            if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("YEAR")) {
                this.dateTime.setRounding(this.dateTime.getChronology().year());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("MONTH")) {
                this.dateTime.setRounding(this.dateTime.getChronology().monthOfYear());
            } else if (StringFunctionHelpers.toStringFromUTF8((int)this.left.start, (int)this.left.end, (DrillBuf)this.left.buffer).equalsIgnoreCase("DAY")) {
                this.dateTime.setRounding(this.dateTime.getChronology().dayOfMonth());
            } else {
                throw new UnsupportedOperationException("date_trunc function supports the following time units for Date: YEAR, MONTH, DAY");
            }
            this.out.value = this.dateTime.getMillis();
        }
    }
}

