/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;

public class GCompareIntVsInt {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsIntVsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value != this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsIntVsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value == this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqIntVsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value >= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanIntVsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value > this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqIntVsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value <= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanIntVsInt
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntVsNullableIntNullLow
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder left;
        @Param
        NullableIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntVsNullableIntNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder left;
        @Param
        NullableIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntVsIntNullLow
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder left;
        @Param
        IntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableIntVsIntNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableIntHolder left;
        @Param
        IntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntVsNullableIntNullLow
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        NullableIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntVsNullableIntNullHigh
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        NullableIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntVsIntNullLow
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareIntVsIntNullHigh
    implements DrillSimpleFunc {
        @Param
        IntHolder left;
        @Param
        IntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }
}

