/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;

public class GCompareFloat4VsFloat4 {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsFloat4VsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value != this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsFloat4VsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value == this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqFloat4VsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value >= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanFloat4VsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value > this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqFloat4VsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value <= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanFloat4VsFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat4VsNullableFloat4NullLow
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder left;
        @Param
        NullableFloat4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat4VsNullableFloat4NullHigh
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder left;
        @Param
        NullableFloat4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat4VsFloat4NullLow
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder left;
        @Param
        Float4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableFloat4VsFloat4NullHigh
    implements DrillSimpleFunc {
        @Param
        NullableFloat4Holder left;
        @Param
        Float4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat4VsNullableFloat4NullLow
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        NullableFloat4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat4VsNullableFloat4NullHigh
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        NullableFloat4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat4VsFloat4NullLow
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareFloat4VsFloat4NullHigh
    implements DrillSimpleFunc {
        @Param
        Float4Holder left;
        @Param
        Float4Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }
}

