/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;

public class GCompareDateVsDate {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsDateVsDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value != this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsDateVsDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value == this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqDateVsDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value >= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanDateVsDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value > this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqDateVsDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value <= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanDateVsDate
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDateVsNullableDateNullLow
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder left;
        @Param
        NullableDateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDateVsNullableDateNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder left;
        @Param
        NullableDateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDateVsDateNullLow
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder left;
        @Param
        DateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDateVsDateNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDateHolder left;
        @Param
        DateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDateVsNullableDateNullLow
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        NullableDateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDateVsNullableDateNullHigh
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        NullableDateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDateVsDateNullLow
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDateVsDateNullHigh
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        DateHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }
}

