/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;

public class GCompareBitVsBit {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsBitVsBit
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value != this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsBitVsBit
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value == this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqBitVsBit
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value >= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanBitVsBit
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value > this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqBitVsBit
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value <= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanBitVsBit
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBitVsNullableBitNullLow
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder left;
        @Param
        NullableBitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBitVsNullableBitNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder left;
        @Param
        NullableBitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBitVsBitNullLow
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder left;
        @Param
        BitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBitVsBitNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableBitHolder left;
        @Param
        BitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBitVsNullableBitNullLow
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        NullableBitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBitVsNullableBitNullHigh
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        NullableBitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBitVsBitNullLow
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBitVsBitNullHigh
    implements DrillSimpleFunc {
        @Param
        BitHolder left;
        @Param
        BitHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }
}

