/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;

public class GCompareBigIntVsBigInt {

    @FunctionTemplate(names={"not_equal", "<>", "!="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class NotEqualsBigIntVsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value != this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"equal", "==", "="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class EqualsBigIntVsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value == this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than_or_equal_to", ">="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanEqBigIntVsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value >= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"greater_than", ">"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class GreaterThanBigIntVsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value > this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than_or_equal_to", "<="}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanEqBigIntVsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value <= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(names={"less_than", "<"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LessThanBigIntVsBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBigIntVsNullableBigIntNullLow
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder left;
        @Param
        NullableBigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBigIntVsNullableBigIntNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder left;
        @Param
        NullableBigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1)));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBigIntVsBigIntNullLow
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableBigIntVsBigIntNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableBigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBigIntVsNullableBigIntNullLow
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        NullableBigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBigIntVsNullableBigIntNullHigh
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        NullableBigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : (this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBigIntVsBigIntNullLow
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareBigIntVsBigIntNullHigh
    implements DrillSimpleFunc {
        @Param
        BigIntHolder left;
        @Param
        BigIntHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value == this.right.value ? 0 : 1);
        }
    }
}

