/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedMathFunctions {
    static final Logger logger = LoggerFactory.getLogger(ExtendedMathFunctions.class);

    private ExtendedMathFunctions() {
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder base;
        @Param
        Decimal18Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.val.value).setScale(this.val.scale).doubleValue();
            this.out.value = Math.log(dblval) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder base;
        @Param
        Decimal9Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.val.value).setScale(this.val.scale).doubleValue();
            this.out.value = Math.log(dblval) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder base;
        @Param
        UInt8Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder base;
        @Param
        UInt4Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder base;
        @Param
        UInt2Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder base;
        @Param
        UInt1Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder base;
        @Param
        TinyIntHolder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder base;
        @Param
        SmallIntHolder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder base;
        @Param
        Float8Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder base;
        @Param
        Float4Holder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder base;
        @Param
        BigIntHolder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBaseInt
    implements DrillSimpleFunc {
        @Param
        IntHolder base;
        @Param
        IntHolder val;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.val.value) / Math.log(this.base.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.toRadians(dblval);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.toRadians(dblval);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="radians", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RadiansInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toRadians(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.toDegrees(dblval);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.toDegrees(dblval);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="degrees", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DegreesInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.toDegrees(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.log(dblval);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.log(dblval);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="log", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class LogInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.log(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.exp(dblval);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.exp(dblval);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="exp", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class ExpInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.exp(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtDecimal18
    implements DrillSimpleFunc {
        @Param
        Decimal18Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.cbrt(dblval);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtDecimal9
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            double dblval = new BigDecimal(this.in.value).setScale(this.in.scale).doubleValue();
            this.out.value = Math.cbrt(dblval);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtUInt8
    implements DrillSimpleFunc {
        @Param
        UInt8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtUInt4
    implements DrillSimpleFunc {
        @Param
        UInt4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtUInt2
    implements DrillSimpleFunc {
        @Param
        UInt2Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtUInt1
    implements DrillSimpleFunc {
        @Param
        UInt1Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtTinyInt
    implements DrillSimpleFunc {
        @Param
        TinyIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtSmallInt
    implements DrillSimpleFunc {
        @Param
        SmallIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtFloat8
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtFloat4
    implements DrillSimpleFunc {
        @Param
        Float4Holder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }

    @FunctionTemplate(name="cbrt", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class CbrtInt
    implements DrillSimpleFunc {
        @Param
        IntHolder in;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = Math.cbrt(this.in.value);
        }
    }
}

