/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.store.PartitionExplorer;
import org.apache.drill.exec.store.PartitionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryExplorers {
    static final Logger logger = LoggerFactory.getLogger(DirectoryExplorers.class);
    private static final String FILE_SEPARATOR = "/";

    @FunctionTemplate(name="imindir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IMinDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        public void setup() {
        }

        public void eval() {
            Iterable subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), new ArrayList(), new ArrayList());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "imindir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            Iterator partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "imindir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            String subPartitionStr = (String)partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = (String)partitionIterator.next();
                if (subPartitionStr.compareToIgnoreCase(curr) <= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split(DirectoryExplorers.FILE_SEPARATOR);
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes();
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="mindir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class MinDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        public void setup() {
        }

        public void eval() {
            Iterable subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), new ArrayList(), new ArrayList());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "mindir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            Iterator partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "mindir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            String subPartitionStr = (String)partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = (String)partitionIterator.next();
                if (subPartitionStr.compareTo(curr) <= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split(DirectoryExplorers.FILE_SEPARATOR);
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes();
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="imaxdir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class IMaxDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        public void setup() {
        }

        public void eval() {
            Iterable subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), new ArrayList(), new ArrayList());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "imaxdir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            Iterator partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "imaxdir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            String subPartitionStr = (String)partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = (String)partitionIterator.next();
                if (subPartitionStr.compareToIgnoreCase(curr) >= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split(DirectoryExplorers.FILE_SEPARATOR);
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes();
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }

    @FunctionTemplate(name="maxdir", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class MaxDir
    implements DrillSimpleFunc {
        @Param
        VarCharHolder schema;
        @Param
        VarCharHolder table;
        @Output
        VarCharHolder out;
        @Inject
        DrillBuf buffer;
        @Inject
        PartitionExplorer partitionExplorer;

        public void setup() {
        }

        public void eval() {
            Iterable subPartitions;
            try {
                subPartitions = this.partitionExplorer.getSubPartitions(StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), new ArrayList(), new ArrayList());
            }
            catch (PartitionNotFoundException e) {
                throw new RuntimeException(String.format("Error in %s function: Table %s does not exist in schema %s ", "maxdir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            Iterator partitionIterator = subPartitions.iterator();
            if (!partitionIterator.hasNext()) {
                throw new RuntimeException(String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.", "maxdir", StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.table), StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)this.schema)));
            }
            String subPartitionStr = (String)partitionIterator.next();
            while (partitionIterator.hasNext()) {
                String curr = (String)partitionIterator.next();
                if (subPartitionStr.compareTo(curr) >= 0) continue;
                subPartitionStr = curr;
            }
            String[] subPartitionParts = subPartitionStr.split(DirectoryExplorers.FILE_SEPARATOR);
            subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
            byte[] result = subPartitionStr.getBytes();
            this.out.buffer = this.buffer = this.buffer.reallocIfNeeded(result.length);
            this.out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
            this.out.start = 0;
            this.out.end = result.length;
        }
    }
}

