/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.drill.common.util.DecimalScalePrecisionAddFunction;
import org.apache.drill.common.util.DecimalScalePrecisionDivideFunction;
import org.apache.drill.common.util.DecimalScalePrecisionModFunction;
import org.apache.drill.common.util.DecimalScalePrecisionMulFunction;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.util.DecimalUtility;

public class Decimal9Functions {

    @FunctionTemplate(name="not equal", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9NotEqual
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value != this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="Equal", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9Equal
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value == this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater than or equal to", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9GreaterThanEq
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value >= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater than", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9GreaterThan
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value > this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less than or equal to", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9LessThanEq
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value <= this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less than", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9LessThan
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value < this.right.value ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal9VsDecimal9NullLow
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal9VsDecimal9NullHigh
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal9VsNullableDecimal9NullLow
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        NullableDecimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.right.isSet == 0) {
                this.out.value = 1;
            } else {
                if (this.left.scale < this.right.scale) {
                    this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                    this.left.scale = this.right.scale;
                } else if (this.right.scale < this.left.scale) {
                    this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                    this.right.scale = this.left.scale;
                }
                this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal9VsNullableDecimal9NullHigh
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        NullableDecimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.right.isSet == 0) {
                this.out.value = -1;
            } else {
                if (this.left.scale < this.right.scale) {
                    this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                    this.left.scale = this.right.scale;
                } else if (this.right.scale < this.left.scale) {
                    this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                    this.right.scale = this.left.scale;
                }
                this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal9VsDecimal9NullLow
    implements DrillSimpleFunc {
        @Param
        NullableDecimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = -1;
            } else {
                if (this.left.scale < this.right.scale) {
                    this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                    this.left.scale = this.right.scale;
                } else if (this.right.scale < this.left.scale) {
                    this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                    this.right.scale = this.left.scale;
                }
                this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal9VsDecimal9NullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDecimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = 1;
            } else {
                if (this.left.scale < this.right.scale) {
                    this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                    this.left.scale = this.right.scale;
                } else if (this.right.scale < this.left.scale) {
                    this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                    this.right.scale = this.left.scale;
                }
                this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal9VsNullableDecimal9NullLow
    implements DrillSimpleFunc {
        @Param
        NullableDecimal9Holder left;
        @Param
        NullableDecimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = this.right.isSet == 0 ? 0 : -1;
            } else if (this.right.isSet == 0) {
                this.out.value = 1;
            } else {
                if (this.left.scale < this.right.scale) {
                    this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                    this.left.scale = this.right.scale;
                } else if (this.right.scale < this.left.scale) {
                    this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                    this.right.scale = this.left.scale;
                }
                this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal9VsNullableDecimal9NullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDecimal9Holder left;
        @Param
        NullableDecimal9Holder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            if (this.left.isSet == 0) {
                this.out.value = this.right.isSet == 0 ? 0 : 1;
            } else if (this.right.isSet == 0) {
                this.out.value = -1;
            } else {
                if (this.left.scale < this.right.scale) {
                    this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                    this.left.scale = this.right.scale;
                } else if (this.right.scale < this.left.scale) {
                    this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                    this.right.scale = this.left.scale;
                }
                this.out.value = this.left.value < this.right.value ? -1 : (this.left.value > this.right.value ? 1 : 0);
            }
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.DECIMAL_SET_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9RoundScaleFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        IntHolder right;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            int scaleFactor = (int)DecimalUtility.getPowerOfTen((int)this.left.scale);
            int newScaleFactor = (int)DecimalUtility.getPowerOfTen((int)this.right.value);
            int truncScaleFactor = (int)DecimalUtility.getPowerOfTen((int)Math.abs(this.left.scale - this.right.value));
            int truncFactor = this.left.scale - this.right.value;
            if (this.right.value >= this.left.scale) {
                this.out.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.value - this.left.scale));
            } else {
                this.out.scale = this.right.value;
                this.out.value = this.left.value / scaleFactor;
                int fractionalPart = this.left.value % scaleFactor;
                int newFractionalPart = (int)DecimalUtility.adjustScaleDivide((long)fractionalPart, (int)truncFactor);
                int truncatedFraction = fractionalPart % truncScaleFactor;
                int digit = Math.abs((int)DecimalUtility.adjustScaleDivide((long)truncatedFraction, (int)(truncFactor - 1)));
                if (digit > 4) {
                    if (this.left.value > 0) {
                        ++newFractionalPart;
                    } else if (this.left.value < 0) {
                        --newFractionalPart;
                    }
                }
                this.out.value = this.out.value * newScaleFactor + newFractionalPart;
            }
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9RoundFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            int scaleFactor = (int)DecimalUtility.getPowerOfTen((int)this.in.scale);
            int extractDigit = scaleFactor / 10;
            this.out.scale = 0;
            this.out.value = this.in.value / scaleFactor;
            int fractionalPart = this.in.value % scaleFactor;
            int digit = Math.abs(fractionalPart / extractDigit);
            if (digit > 4) {
                if (this.in.value > 0) {
                    ++this.out.value;
                } else if (this.in.value < 0) {
                    --this.out.value;
                }
            }
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9FloorFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            int fractionalPart;
            int scaleFactor = (int)DecimalUtility.getPowerOfTen((int)this.in.scale);
            this.out.scale = 0;
            this.out.value = this.in.value / scaleFactor;
            if (this.in.value < 0 && (fractionalPart = this.in.value % scaleFactor) != 0) {
                --this.out.value;
            }
        }
    }

    @FunctionTemplate(names={"ceil", "ceiling"}, scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9CeilFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            int scaleFactor = (int)DecimalUtility.getPowerOfTen((int)this.in.scale);
            int integerPart = this.in.value / scaleFactor;
            int fractionalPart = this.in.value % scaleFactor;
            if (fractionalPart != 0 && this.in.value >= 0) {
                ++integerPart;
            }
            this.out.scale = 0;
            this.out.value = integerPart;
        }
    }

    @FunctionTemplate(names={"trunc", "truncate"}, scope=FunctionTemplate.FunctionScope.DECIMAL_SET_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9TruncateScaleFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        IntHolder right;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = (int)DecimalUtility.adjustScaleDivide((long)this.left.value, (int)(this.left.scale - this.right.value));
            this.out.precision = 9;
            this.out.scale = this.right.value;
        }
    }

    @FunctionTemplate(names={"trunc", "truncate"}, scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9TruncFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = (int)DecimalUtility.adjustScaleDivide((long)this.in.value, (int)this.in.scale);
            this.out.precision = 9;
            this.out.scale = 0;
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9SignFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.in.value < 0 ? -1 : (this.in.value > 0 ? 1 : 0);
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.DECIMAL_MOD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9ModFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Output
        Decimal9Holder result;

        public void setup() {
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionModFunction resultScalePrec = new DecimalScalePrecisionModFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.precision = this.outputPrecision;
            this.result.scale = this.outputScale;
            BigDecimal numerator = new BigDecimal(BigInteger.valueOf(this.left.value), this.left.scale);
            BigDecimal denominator = new BigDecimal(BigInteger.valueOf(this.right.value), this.right.scale);
            BigDecimal output = numerator.remainder(denominator);
            output.setScale(this.result.scale, 4);
            this.result.value = output.unscaledValue().intValue();
        }
    }

    @FunctionTemplate(name="exact_divide", scope=FunctionTemplate.FunctionScope.DECIMAL_DIV_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9DivideFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Output
        Decimal9Holder result;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;

        public void setup() {
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionDivideFunction resultScalePrec = new DecimalScalePrecisionDivideFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.scale = this.outputScale;
            this.result.precision = this.outputPrecision;
            BigDecimal numerator = new BigDecimal(BigInteger.valueOf(this.left.value), this.left.scale);
            BigDecimal denominator = new BigDecimal(BigInteger.valueOf(this.right.value), this.right.scale);
            BigDecimal output = numerator.divide(denominator, this.result.scale, 4);
            this.result.value = output.unscaledValue().intValue();
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9AbsFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder in;
        @Output
        Decimal9Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.precision = 9;
            this.out.scale = this.in.scale;
            this.out.value = this.in.value;
            if (this.out.value < 0) {
                this.out.value *= -1;
            }
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.DECIMAL_MUL_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9MultiplyFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Output
        Decimal9Holder result;

        public void setup() {
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionMulFunction resultScalePrec = new DecimalScalePrecisionMulFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.value = this.left.value * this.right.value;
            this.result.precision = this.outputPrecision;
            this.result.scale = this.outputScale;
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.DECIMAL_ADD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9SubtractFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Output
        Decimal9Holder result;

        public void setup() {
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionAddFunction resultScalePrec = new DecimalScalePrecisionAddFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.result.value = this.left.value - this.right.value;
            this.result.precision = this.outputPrecision;
            this.result.scale = this.outputScale;
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.DECIMAL_ADD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal9AddFunction
    implements DrillSimpleFunc {
        @Param
        Decimal9Holder left;
        @Param
        Decimal9Holder right;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Output
        Decimal9Holder result;

        public void setup() {
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionAddFunction resultScalePrec = new DecimalScalePrecisionAddFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            if (this.left.scale < this.right.scale) {
                this.left.value = (int)DecimalUtility.adjustScaleMultiply((long)this.left.value, (int)(this.right.scale - this.left.scale));
                this.left.scale = this.right.scale;
            } else if (this.right.scale < this.left.scale) {
                this.right.value = (int)DecimalUtility.adjustScaleMultiply((long)this.right.value, (int)(this.left.scale - this.right.scale));
                this.right.scale = this.left.scale;
            }
            this.result.value = this.left.value + this.right.value;
            this.result.precision = this.outputPrecision;
            this.result.scale = this.outputScale;
        }
    }
}

