/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.util.DecimalScalePrecisionAddFunction;
import org.apache.drill.common.util.DecimalScalePrecisionDivideFunction;
import org.apache.drill.common.util.DecimalScalePrecisionModFunction;
import org.apache.drill.common.util.DecimalScalePrecisionMulFunction;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;

public class Decimal38SparseFunctions {

    @FunctionTemplate(name="not equal", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseNotEqual
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
            this.out.value = cmp != 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="Equal", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseEqual
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
            this.out.value = cmp == 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater than or equal to", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseGreaterThanEq
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
            this.out.value = cmp > -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater than", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseGreaterThan
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
            this.out.value = cmp == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less than or equal to", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseLessThanEq
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
            this.out.value = cmp < 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less than", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseLessThan
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
            this.out.value = cmp == -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal38SparseVsDecimal38SparseNullLow
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal38SparseVsDecimal38SparseNullHigh
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal38SparseVsNullableDecimal38SparseNullLow
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        NullableDecimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal38SparseVsNullableDecimal38SparseNullHigh
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        NullableDecimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal38SparseVsDecimal38SparseNullLow
    implements DrillSimpleFunc {
        @Param
        NullableDecimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal38SparseVsDecimal38SparseNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDecimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal38SparseVsNullableDecimal38SparseNullLow
    implements DrillSimpleFunc {
        @Param
        NullableDecimal38SparseHolder left;
        @Param
        NullableDecimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal38SparseVsNullableDecimal38SparseNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDecimal38SparseHolder left;
        @Param
        NullableDecimal38SparseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : DecimalUtility.compareSparseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal38SparseHolder.getSign(this.left.start, this.left.buffer), (int)this.left.scale, (int)this.left.precision, (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal38SparseHolder.getSign(this.right.start, this.right.buffer), (int)this.right.precision, (int)this.right.scale, (int)24, (int)6, (boolean)false));
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.DECIMAL_SET_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseRoundScaleFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        IntHolder right;
        @Output
        Decimal38SparseHolder result;

        public void setup() {
        }

        public void eval() {
            this.result.scale = this.right.value;
            this.result.precision = this.left.precision;
            this.result.buffer = this.left.buffer;
            this.result.start = this.left.start;
            boolean sign = Decimal38SparseHolder.getSign(this.left.start, this.left.buffer);
            DecimalUtility.roundDecimal((DrillBuf)this.result.buffer, (int)this.result.start, (int)6, (int)this.result.scale, (int)this.left.scale);
            Decimal38SparseHolder.setSign(sign, this.result.start, this.result.buffer);
        }
    }

    @FunctionTemplate(name="round", scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseRoundFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.scale = 0;
            this.out.precision = this.in.precision;
            this.out.buffer = this.in.buffer;
            this.out.start = this.in.start;
            boolean sign = Decimal38SparseHolder.getSign(this.in.start, this.in.buffer);
            boolean roundUp = false;
            int scaleIndex = 6 - DecimalUtility.roundUp((int)this.in.scale);
            if (scaleIndex < 6) {
                int fractionalPart = Decimal38SparseHolder.getInteger(scaleIndex, this.out.start, this.out.buffer);
                int digit = fractionalPart / 100000000;
                if (digit > 4) {
                    roundUp = true;
                }
            }
            int srcIntIndex = scaleIndex - 1;
            int destIndex = 5;
            while (srcIntIndex >= 0) {
                int n = destIndex--;
                Decimal38SparseHolder.setInteger(n, Decimal38SparseHolder.getInteger(srcIntIndex--, this.out.start, this.out.buffer), this.out.start, this.out.buffer);
            }
            while (destIndex >= 0) {
                Decimal38SparseHolder.setInteger(destIndex--, 0, this.out.start, this.out.buffer);
            }
            srcIntIndex = 5;
            if (roundUp) {
                while (srcIntIndex >= 0) {
                    int value = Decimal38SparseHolder.getInteger(srcIntIndex, this.out.start, this.out.buffer) + 1;
                    if (value >= 1000000000) {
                        Decimal38SparseHolder.setInteger(srcIntIndex--, value % 1000000000, this.out.start, this.out.buffer);
                        value /= 1000000000;
                        continue;
                    }
                    Decimal38SparseHolder.setInteger(srcIntIndex--, value, this.out.start, this.out.buffer);
                    break;
                }
            }
            Decimal38SparseHolder.setSign(sign, this.out.start, this.out.buffer);
        }
    }

    @FunctionTemplate(names={"trunc", "truncate"}, scope=FunctionTemplate.FunctionScope.DECIMAL_SET_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseTruncateScaleFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        IntHolder right;
        @Output
        Decimal38SparseHolder result;

        public void setup() {
        }

        public void eval() {
            this.result.scale = this.right.value;
            this.result.precision = this.left.precision;
            this.result.buffer = this.left.buffer;
            this.result.start = this.left.start;
            boolean sign = Decimal38SparseHolder.getSign(this.left.start, this.left.buffer);
            int newScaleRoundedUp = DecimalUtility.roundUp((int)this.right.value);
            int origScaleRoundedUp = DecimalUtility.roundUp((int)this.left.scale);
            if (this.right.value < this.left.scale) {
                int truncateFactor;
                int srcIntIndex = 6 - origScaleRoundedUp - 1;
                int srcIndex = srcIntIndex + newScaleRoundedUp;
                int destIndex = 5;
                if (srcIndex != destIndex) {
                    while (srcIndex >= 0) {
                        int n = destIndex--;
                        Decimal38SparseHolder.setInteger(n, Decimal38SparseHolder.getInteger(srcIndex--, this.result.start, this.result.buffer), this.result.start, this.result.buffer);
                    }
                    while (destIndex >= 0) {
                        Decimal38SparseHolder.setInteger(destIndex--, 0, this.result.start, this.result.buffer);
                    }
                }
                if ((truncateFactor = 9 - this.right.value % 9) != 9) {
                    truncateFactor = (int)DecimalUtility.getPowerOfTen((int)truncateFactor);
                    int fractionalDigits = Decimal38SparseHolder.getInteger(5, this.result.start, this.result.buffer);
                    Decimal38SparseHolder.setInteger(5, (fractionalDigits /= truncateFactor) * truncateFactor, this.result.start, this.result.buffer);
                }
            } else if (this.right.value > this.left.scale && newScaleRoundedUp > origScaleRoundedUp) {
                int srcIndex = 0;
                int destIndex = newScaleRoundedUp - origScaleRoundedUp;
                while (srcIndex < destIndex) {
                    if (Decimal38SparseHolder.getInteger(srcIndex++, this.result.start, this.result.buffer) == 0) continue;
                    throw new DrillRuntimeException("Truncate resulting in loss of integer part, reduce scale specified");
                }
                srcIndex = 0;
                while (destIndex < 6) {
                    int n = srcIndex++;
                    Decimal38SparseHolder.setInteger(n, Decimal38SparseHolder.getInteger(destIndex++, this.result.start, this.result.buffer), this.result.start, this.result.buffer);
                }
                while (srcIndex < 6) {
                    Decimal38SparseHolder.setInteger(srcIndex++, 0, this.result.start, this.result.buffer);
                }
            }
            Decimal38SparseHolder.setSign(sign, this.result.start, this.result.buffer);
        }
    }

    @FunctionTemplate(names={"trunc", "truncate"}, scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseTruncateFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.scale = 0;
            this.out.precision = this.in.precision;
            this.out.buffer = this.in.buffer;
            this.out.start = this.in.start;
            boolean sign = Decimal38SparseHolder.getSign(this.in.start, this.in.buffer);
            int srcIntIndex = 6 - DecimalUtility.roundUp((int)this.in.scale) - 1;
            int destIndex = 5;
            while (srcIntIndex >= 0) {
                int n = destIndex--;
                Decimal38SparseHolder.setInteger(n, Decimal38SparseHolder.getInteger(srcIntIndex--, this.out.start, this.out.buffer), this.out.start, this.out.buffer);
            }
            while (destIndex >= 0) {
                Decimal38SparseHolder.setInteger(destIndex--, 0, this.out.start, this.out.buffer);
            }
            Decimal38SparseHolder.setSign(sign, this.out.start, this.out.buffer);
        }
    }

    @FunctionTemplate(name="floor", scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseFloorFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
        }

        public void eval() {
            int scaleStartIndex;
            this.out.scale = 0;
            this.out.precision = this.in.precision;
            this.out.buffer = this.in.buffer;
            this.out.start = this.in.start;
            boolean sign = Decimal38SparseHolder.getSign(this.in.start, this.in.buffer);
            int carry = 0;
            int srcIntIndex = scaleStartIndex - 1;
            if (sign) {
                for (scaleStartIndex = 6 - DecimalUtility.roundUp((int)this.in.scale); scaleStartIndex < 6; ++scaleStartIndex) {
                    if (Decimal38SparseHolder.getInteger(scaleStartIndex, this.out.start, this.out.buffer) == 0) continue;
                    carry = 1;
                    break;
                }
            }
            int destIndex = 5;
            while (srcIntIndex >= 0) {
                int n = destIndex--;
                Decimal38SparseHolder.setInteger(n, Decimal38SparseHolder.getInteger(srcIntIndex--, this.out.start, this.out.buffer), this.out.start, this.out.buffer);
            }
            while (destIndex >= 0) {
                Decimal38SparseHolder.setInteger(destIndex--, 0, this.out.start, this.out.buffer);
            }
            if (carry != 0) {
                destIndex = 5;
                while (destIndex >= 0) {
                    int intValue = Decimal38SparseHolder.getInteger(destIndex, this.out.start, this.out.buffer);
                    if ((intValue += carry) >= 1000000000) {
                        Decimal38SparseHolder.setInteger(destIndex--, intValue % 1000000000, this.out.start, this.out.buffer);
                        carry = intValue / 1000000000;
                        continue;
                    }
                    Decimal38SparseHolder.setInteger(destIndex--, intValue, this.out.start, this.out.buffer);
                    break;
                }
            }
            Decimal38SparseHolder.setSign(sign, this.out.start, this.out.buffer);
        }
    }

    @FunctionTemplate(names={"ceil", "ceiling"}, scope=FunctionTemplate.FunctionScope.DECIMAL_ZERO_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseCeilFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
        }

        public void eval() {
            int scaleStartIndex;
            this.out.scale = 0;
            this.out.precision = this.in.precision;
            this.out.buffer = this.in.buffer;
            this.out.start = this.in.start;
            boolean sign = Decimal38SparseHolder.getSign(this.in.start, this.in.buffer);
            int carry = 0;
            int srcIntIndex = scaleStartIndex - 1;
            if (!sign) {
                for (scaleStartIndex = 6 - DecimalUtility.roundUp((int)this.in.scale); scaleStartIndex < 6; ++scaleStartIndex) {
                    if (Decimal38SparseHolder.getInteger(scaleStartIndex, this.out.start, this.out.buffer) == 0) continue;
                    carry = 1;
                    break;
                }
            }
            int destIndex = 5;
            while (srcIntIndex >= 0) {
                int n = destIndex--;
                Decimal38SparseHolder.setInteger(n, Decimal38SparseHolder.getInteger(srcIntIndex--, this.out.start, this.out.buffer), this.out.start, this.out.buffer);
            }
            while (destIndex >= 0) {
                Decimal38SparseHolder.setInteger(destIndex--, 0, this.out.start, this.out.buffer);
            }
            if (carry != 0) {
                destIndex = 5;
                while (destIndex >= 0) {
                    int intValue = Decimal38SparseHolder.getInteger(destIndex, this.out.start, this.out.buffer);
                    if ((intValue += carry) >= 1000000000) {
                        Decimal38SparseHolder.setInteger(destIndex--, intValue % 1000000000, this.out.start, this.out.buffer);
                        carry = intValue / 1000000000;
                        continue;
                    }
                    Decimal38SparseHolder.setInteger(destIndex--, intValue, this.out.start, this.out.buffer);
                    break;
                }
            }
            Decimal38SparseHolder.setSign(sign, this.out.start, this.out.buffer);
        }
    }

    @FunctionTemplate(name="sign", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseSignFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            boolean zeroValue = true;
            if (Decimal38SparseHolder.getSign(this.in.start, this.in.buffer)) {
                this.out.value = -1;
            } else {
                for (int i = 0; i < 6; ++i) {
                    if (Decimal38SparseHolder.getInteger(i, this.in.start, this.in.buffer) == 0) continue;
                    zeroValue = false;
                    break;
                }
                this.out.value = zeroValue ? 0 : 1;
            }
        }
    }

    @FunctionTemplate(name="abs", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseAbsFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder in;
        @Output
        Decimal38SparseHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.scale = this.in.scale;
            this.out.precision = this.in.precision;
            this.out.buffer = this.in.buffer;
            this.out.start = this.in.start;
            this.out.buffer.setInt(this.out.start, this.out.buffer.getInt(this.out.start) & Integer.MAX_VALUE);
        }
    }

    @FunctionTemplate(name="mod", scope=FunctionTemplate.FunctionScope.DECIMAL_MOD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseModFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        Decimal38SparseHolder result;
        @Inject
        DrillBuf buffer;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;

        public void setup() {
            int size = 24;
            this.buffer = this.buffer.reallocIfNeeded(size);
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionModFunction resultScalePrec = new DecimalScalePrecisionModFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.scale = this.outputScale;
            this.result.precision = this.outputPrecision;
            this.result.buffer = this.buffer;
            this.result.start = 0;
            BigDecimal numerator = DecimalUtility.getBigDecimalFromDrillBuf((DrillBuf)this.left.buffer, (int)this.left.start, (int)6, (int)this.left.scale, (boolean)true);
            BigDecimal denominator = DecimalUtility.getBigDecimalFromDrillBuf((DrillBuf)this.right.buffer, (int)this.right.start, (int)6, (int)this.right.scale, (boolean)true);
            BigDecimal output = numerator.remainder(denominator);
            output.setScale(this.result.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)output, (DrillBuf)this.result.buffer, (int)this.result.start, (int)this.result.scale, (int)this.result.precision, (int)6);
        }
    }

    @FunctionTemplate(name="exact_divide", scope=FunctionTemplate.FunctionScope.DECIMAL_DIV_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseDivideFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Output
        Decimal38SparseHolder result;
        @Inject
        DrillBuf buffer;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;

        public void setup() {
            int size = 24;
            this.buffer = this.buffer.reallocIfNeeded(size);
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionDivideFunction resultScalePrec = new DecimalScalePrecisionDivideFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.scale = this.outputScale;
            this.result.precision = this.outputPrecision;
            this.result.buffer = this.buffer;
            this.result.start = 0;
            BigDecimal numerator = DecimalUtility.getBigDecimalFromDrillBuf((DrillBuf)this.left.buffer, (int)this.left.start, (int)6, (int)this.left.scale, (boolean)true);
            BigDecimal denominator = DecimalUtility.getBigDecimalFromDrillBuf((DrillBuf)this.right.buffer, (int)this.right.start, (int)6, (int)this.right.scale, (boolean)true);
            BigDecimal output = numerator.divide(denominator, this.result.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)output, (DrillBuf)this.result.buffer, (int)this.result.start, (int)this.result.scale, (int)this.result.precision, (int)6);
        }
    }

    @FunctionTemplate(name="multiply", scope=FunctionTemplate.FunctionScope.DECIMAL_MUL_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseMultiplyFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Inject
        DrillBuf buffer;
        @Workspace
        int[] tempResult;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Output
        Decimal38SparseHolder result;

        public void setup() {
            int size = 24;
            this.buffer = this.buffer.reallocIfNeeded(size);
            this.tempResult = new int[36];
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            int rightIndex;
            int leftIndex;
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionMulFunction resultScalePrec = new DecimalScalePrecisionMulFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.scale = this.outputScale;
            this.result.precision = this.outputPrecision;
            this.result.buffer = this.buffer;
            this.result.start = 0;
            for (int i = 0; i < 36; ++i) {
                this.tempResult[i] = 0;
            }
            int leftStopIndex = 6 - DecimalUtility.roundUp((int)this.left.scale);
            for (leftIndex = 0; leftIndex < leftStopIndex; ++leftIndex) {
                if (Decimal38SparseHolder.getInteger(leftIndex, this.left.start, this.left.buffer) > 0) break;
            }
            int leftIntegerSize = leftStopIndex - leftIndex;
            int rightStopIndex = 6 - DecimalUtility.roundUp((int)this.right.scale);
            for (rightIndex = 0; rightIndex < rightStopIndex; ++rightIndex) {
                if (Decimal38SparseHolder.getInteger(rightIndex, this.right.start, this.right.buffer) > 0) break;
            }
            int rightIntegerSize = rightStopIndex - rightIndex;
            int resultIntegerSize = leftIntegerSize + rightIntegerSize;
            int resultScaleSize = DecimalUtility.roundUp((int)(this.left.scale + this.right.scale));
            int leftSize = 6 - 1;
            int rightSize = 6 - 1;
            int resultIndex = this.tempResult.length - 1;
            int currentIndex = 0;
            for (int i = leftSize; i >= leftIndex; --i) {
                currentIndex = resultIndex;
                int carry = 0;
                for (int j = rightSize; j >= rightIndex; --j) {
                    long mulResult = (long)Decimal38SparseHolder.getInteger(j, this.right.start, this.right.buffer) * (long)Decimal38SparseHolder.getInteger(i, this.left.start, this.left.buffer);
                    long tempSum = (long)this.tempResult[currentIndex] + mulResult + (long)carry;
                    if (tempSum >= 1000000000L) {
                        this.tempResult[currentIndex] = (int)(tempSum % 1000000000L);
                        carry = (int)(tempSum / 1000000000L);
                    } else {
                        this.tempResult[currentIndex] = (int)tempSum;
                        carry = 0;
                    }
                    --currentIndex;
                }
                if (carry > 0) {
                    int n = currentIndex;
                    this.tempResult[n] = this.tempResult[n] + carry;
                }
                --resultIndex;
            }
            resultScaleSize = DecimalUtility.roundUp((int)this.result.scale);
            if (this.result.scale < this.left.scale + this.right.scale) {
                int carry;
                int lastScaleIndex = currentIndex + resultIntegerSize + resultScaleSize - 1;
                int roundFactor = (int)DecimalUtility.getPowerOfTen((int)(9 - (this.result.scale + 1) % 9));
                int roundIndex = currentIndex + resultIntegerSize + DecimalUtility.roundUp((int)(this.result.scale + 1)) - 1;
                int n = carry = this.tempResult[roundIndex] / roundFactor % 10 > 4 ? 1 : 0;
                if (this.result.scale > 0) {
                    int scaleFactor = (int)DecimalUtility.getPowerOfTen((int)(9 - this.result.scale % 9));
                    int n2 = lastScaleIndex;
                    this.tempResult[n2] = this.tempResult[n2] / scaleFactor;
                    int n3 = lastScaleIndex;
                    this.tempResult[n3] = this.tempResult[n3] * scaleFactor;
                    carry *= scaleFactor;
                }
                while (carry > 0 && lastScaleIndex >= 0) {
                    int tempSum = this.tempResult[lastScaleIndex] + carry;
                    if (tempSum >= 1000000000) {
                        this.tempResult[lastScaleIndex] = tempSum % 1000000000;
                        carry = tempSum / 1000000000;
                    } else {
                        this.tempResult[lastScaleIndex] = tempSum;
                        carry = 0;
                    }
                    --lastScaleIndex;
                }
                if (lastScaleIndex + 1 < currentIndex) {
                    ++resultIntegerSize;
                    currentIndex = lastScaleIndex + 1;
                }
            }
            if (resultIntegerSize > 6) {
                throw new DrillRuntimeException("Cannot fit multiplication result in the given decimal type");
            }
            int outputIndex = 6 - 1;
            for (int i = currentIndex + resultIntegerSize + resultScaleSize - 1; i >= currentIndex; --i) {
                Decimal38SparseHolder.setInteger(outputIndex--, this.tempResult[i], this.result.start, this.result.buffer);
            }
            while (outputIndex >= 0) {
                Decimal38SparseHolder.setInteger(outputIndex--, 0, this.result.start, this.result.buffer);
            }
            Decimal38SparseHolder.setSign(Decimal38SparseHolder.getSign(this.left.start, this.left.buffer) != Decimal38SparseHolder.getSign(this.right.start, this.right.buffer), this.result.start, this.result.buffer);
        }
    }

    @FunctionTemplate(name="add", scope=FunctionTemplate.FunctionScope.DECIMAL_ADD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseAddFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Inject
        DrillBuf buffer;
        @Output
        Decimal38SparseHolder result;

        public void setup() {
            int size = 24;
            this.buffer = this.buffer.reallocIfNeeded(size);
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionAddFunction resultScalePrec = new DecimalScalePrecisionAddFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.precision = this.outputPrecision;
            this.result.scale = this.outputScale;
            this.result.buffer = this.buffer;
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.left.buffer, (int)this.left.start, (int)6, (int)this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.right.buffer, (int)this.right.start, (int)6, (int)this.right.scale);
            BigDecimal addResult = leftInput.add(rightInput);
            addResult.setScale(this.result.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)addResult, (DrillBuf)this.result.buffer, (int)this.result.start, (int)this.result.scale, (int)this.result.precision, (int)6);
        }
    }

    @FunctionTemplate(name="subtract", scope=FunctionTemplate.FunctionScope.DECIMAL_ADD_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal38SparseSubtractFunction
    implements DrillSimpleFunc {
        @Param
        Decimal38SparseHolder left;
        @Param
        Decimal38SparseHolder right;
        @Inject
        DrillBuf buffer;
        @Workspace
        int outputScale;
        @Workspace
        int outputPrecision;
        @Output
        Decimal38SparseHolder result;

        public void setup() {
            int size = 24;
            this.buffer = this.buffer.reallocIfNeeded(size);
            this.outputPrecision = Integer.MIN_VALUE;
        }

        public void eval() {
            if (this.outputPrecision == Integer.MIN_VALUE) {
                DecimalScalePrecisionAddFunction resultScalePrec = new DecimalScalePrecisionAddFunction(this.left.precision, this.left.scale, this.right.precision, this.right.scale);
                this.outputScale = resultScalePrec.getOutputScale();
                this.outputPrecision = resultScalePrec.getOutputPrecision();
            }
            this.result.precision = this.outputPrecision;
            this.result.scale = this.outputScale;
            this.result.buffer = this.buffer;
            this.result.start = 0;
            BigDecimal leftInput = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.left.buffer, (int)this.left.start, (int)6, (int)this.left.scale);
            BigDecimal rightInput = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.right.buffer, (int)this.right.start, (int)6, (int)this.right.scale);
            BigDecimal addResult = leftInput.subtract(rightInput);
            addResult.setScale(this.result.scale, 4);
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)addResult, (DrillBuf)this.result.buffer, (int)this.result.start, (int)this.result.scale, (int)this.result.precision, (int)6);
        }
    }
}

