/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.util.DecimalUtility;

public class Decimal28DenseFunctions {

    @FunctionTemplate(name="not equal", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal28DenseNotEqual
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
            this.out.value = cmp != 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="Equal", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal28DenseEqual
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
            this.out.value = cmp == 0 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater than or equal to", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal28DenseGreaterThanEq
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
            this.out.value = cmp > -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="greater than", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal28DenseGreaterThan
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
            this.out.value = cmp == 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less than or equal to", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal28DenseLessThanEq
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
            this.out.value = cmp < 1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="less than", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Decimal28DenseLessThan
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        BitHolder out;

        public void setup() {
        }

        public void eval() {
            int cmp = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
            this.out.value = cmp == -1 ? 1 : 0;
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal28DenseVsDecimal28DenseNullLow
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal28DenseVsDecimal28DenseNullHigh
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal28DenseVsNullableDecimal28DenseNullLow
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        NullableDecimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? 1 : DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareDecimal28DenseVsNullableDecimal28DenseNullHigh
    implements DrillSimpleFunc {
        @Param
        Decimal28DenseHolder left;
        @Param
        NullableDecimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.right.isSet == 0 ? -1 : DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)Decimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal28DenseVsDecimal28DenseNullLow
    implements DrillSimpleFunc {
        @Param
        NullableDecimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? -1 : DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal28DenseVsDecimal28DenseNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDecimal28DenseHolder left;
        @Param
        Decimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? 1 : DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)Decimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12);
        }
    }

    @FunctionTemplate(name="compare_to_nulls_low", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal28DenseVsNullableDecimal28DenseNullLow
    implements DrillSimpleFunc {
        @Param
        NullableDecimal28DenseHolder left;
        @Param
        NullableDecimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : -1) : (this.right.isSet == 0 ? 1 : DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12));
        }
    }

    @FunctionTemplate(name="compare_to_nulls_high", scope=FunctionTemplate.FunctionScope.DECIMAL_MAX_SCALE, nulls=FunctionTemplate.NullHandling.INTERNAL)
    public static class GCompareNullableDecimal28DenseVsNullableDecimal28DenseNullHigh
    implements DrillSimpleFunc {
        @Param
        NullableDecimal28DenseHolder left;
        @Param
        NullableDecimal28DenseHolder right;
        @Output
        IntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = this.left.isSet == 0 ? (this.right.isSet == 0 ? 0 : 1) : (this.right.isSet == 0 ? -1 : DecimalUtility.compareDenseBytes((DrillBuf)this.left.buffer, (int)this.left.start, (boolean)NullableDecimal28DenseHolder.getSign(this.left.start, this.left.buffer), (DrillBuf)this.right.buffer, (int)this.right.start, (boolean)NullableDecimal28DenseHolder.getSign(this.right.start, this.right.buffer), (int)12));
        }
    }
}

