/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class DateIntervalYearFunctions {

    @FunctionTemplate(names={"date_sub", "subtract", "date_diff"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateIntervalYearSubtractFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        IntervalYearHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addMonths(this.right.value * -1);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntervalYearDateAddFunction
    implements DrillSimpleFunc {
        @Param
        IntervalYearHolder right;
        @Param
        DateHolder left;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addMonths(this.right.value);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateIntervalYearAddFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        IntervalYearHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        TimeStampHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addMonths(this.right.value);
            this.out.value = this.temp.getMillis();
        }
    }
}

