/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class DateIntFunctions {

    @FunctionTemplate(names={"date_sub", "subtract", "date_diff"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateIntSubtractFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        IntHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays(this.right.value * -1);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IntDateAddFunction
    implements DrillSimpleFunc {
        @Param
        IntHolder right;
        @Param
        DateHolder left;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays(this.right.value);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateIntAddFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        IntHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays(this.right.value);
            this.out.value = this.temp.getMillis();
        }
    }
}

