/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class DateBigIntFunctions {

    @FunctionTemplate(names={"date_sub", "subtract", "date_diff"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateBigIntSubtractFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        BigIntHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays((int)this.right.value * -1);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class BigIntDateAddFunction
    implements DrillSimpleFunc {
        @Param
        BigIntHolder right;
        @Param
        DateHolder left;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays((int)this.right.value);
            this.out.value = this.temp.getMillis();
        }
    }

    @FunctionTemplate(names={"date_add", "add"}, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class DateBigIntAddFunction
    implements DrillSimpleFunc {
        @Param
        DateHolder left;
        @Param
        BigIntHolder right;
        @Workspace
        MutableDateTime temp;
        @Output
        DateHolder out;

        public void setup() {
            this.temp = new MutableDateTime(DateTimeZone.UTC);
        }

        public void eval() {
            this.temp.setMillis(this.left.value);
            this.temp.addDays((int)this.right.value);
            this.out.value = this.temp.getMillis();
        }
    }
}

