/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.proto.UserBitShared;
import org.junit.Ignore;
import org.junit.Test;

public class TestSchemaPathMaterialization
extends BaseTestQuery {
    @Test
    public void testSingleProjectionFromMultiLevelRepeatedList() throws Exception {
        String query = "select t.odd[2][0][0] v1  from cp.`complex/json/repeated_list.json` t";
        TestSchemaPathMaterialization.testBuilder().sqlQuery("select t.odd[2][0][0] v1  from cp.`complex/json/repeated_list.json` t").ordered().baselineColumns("v1").baselineValues(5L).go();
    }

    @Test
    public void testMultiProjectionFromMultiLevelRepeatedListWhenFieldsExist() throws Exception {
        String query = "select t.odd[0][0][0] v1, t.odd[0][1][0] v2, t.odd[0][2][0] v3  from cp.`complex/json/repeated_list.json` t";
        TestSchemaPathMaterialization.testRunAndPrint(UserBitShared.QueryType.SQL, "select t.odd[0][0][0] v1, t.odd[0][1][0] v2, t.odd[0][2][0] v3  from cp.`complex/json/repeated_list.json` t");
        TestSchemaPathMaterialization.testBuilder().sqlQuery("select t.odd[0][0][0] v1, t.odd[0][1][0] v2, t.odd[0][2][0] v3  from cp.`complex/json/repeated_list.json` t").ordered().baselineColumns("v1", "v2", "v3").baselineValues(1L, null, 3L).go();
    }

    @Test
    @Ignore(value="Ignored until DRILL-2539 is fixed")
    public void testProjectionFromMultiLevelRepeatedList() throws Exception {
        String query = "select t.odd[0][1][0] v1, t.odd[0][1][0] v2, t.odd[0][2][0] v3,  t.odd[1] v4, t.odd[2][0][0] v5, t.odd[2][1][0] v6 from cp.`complex/json/repeated_list.json` t";
        TestSchemaPathMaterialization.testRunAndPrint(UserBitShared.QueryType.SQL, "select t.odd[0][1][0] v1, t.odd[0][1][0] v2, t.odd[0][2][0] v3,  t.odd[1] v4, t.odd[2][0][0] v5, t.odd[2][1][0] v6 from cp.`complex/json/repeated_list.json` t");
        TestSchemaPathMaterialization.testBuilder().sqlQuery("select t.odd[0][1][0] v1, t.odd[0][1][0] v2, t.odd[0][2][0] v3,  t.odd[1] v4, t.odd[2][0][0] v5, t.odd[2][1][0] v6 from cp.`complex/json/repeated_list.json` t").ordered().baselineColumns("v1", "v2", "v3", "v4", "v5", "v6").baselineValues(1L, null, 3L, null, 5L, null).go();
    }

    @Test
    @Ignore(value="Ignored until DRILL-2539 is fixed")
    public void testProjectionFromMultiLevelRepeatedListMap() throws Exception {
        String query = "select t.odd[0][0].val[0] v1, t.odd[0][0].val[0] v2,  from cp.`complex/json/repeated_list_map.json` t";
        TestSchemaPathMaterialization.testRunAndPrint(UserBitShared.QueryType.SQL, "select t.odd[0][0].val[0] v1, t.odd[0][0].val[0] v2,  from cp.`complex/json/repeated_list_map.json` t");
        TestSchemaPathMaterialization.testBuilder().sqlQuery("select t.odd[0][0].val[0] v1, t.odd[0][0].val[0] v2,  from cp.`complex/json/repeated_list_map.json` t").ordered().baselineColumns("v1", "v2").baselineValues(1L, 3L).go();
    }

    @Test
    public void testProjectionMultipleFiles() throws Exception {
        String query = "select t.oooa.oa.oab.oabc[1].rowValue1 rowValue from dfs.`${WORKING_PATH}/src/test/resources/complex/json/multiple/*.json` t";
        TestSchemaPathMaterialization.testBuilder().sqlQuery("select t.oooa.oa.oab.oabc[1].rowValue1 rowValue from dfs.`${WORKING_PATH}/src/test/resources/complex/json/multiple/*.json` t").unOrdered().jsonBaselineFile("complex/drill-1962-result.json").go();
    }
}

