/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr;

import mockit.Expectations;
import mockit.Injectable;
import mockit.NonStrict;
import mockit.NonStrictExpectations;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.physical.impl.project.Projector;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTest
extends ExecTest {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionTest.class);
    private final DrillConfig c = DrillConfig.create();
    private final FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);

    @Test
    public void testBasicExpression(@Injectable RecordBatch batch) throws Exception {
        System.out.println(this.getExpressionCode("if(true) then 1 else 0 end", batch));
    }

    @Test
    public void testExprParseUpperExponent(@Injectable RecordBatch batch) throws Exception {
        this.getExpressionCode("multiply(`$f0`, 1.0E-4)", batch);
    }

    @Test
    public void testExprParseLowerExponent(@Injectable RecordBatch batch) throws Exception {
        this.getExpressionCode("multiply(`$f0`, 1.0e-4)", batch);
    }

    @Test
    public void testSpecial(final @Injectable RecordBatch batch, @Injectable ValueVector vector) throws Exception {
        final TypeProtos.MajorType type = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT);
        final TypedFieldId tfid = new TypedFieldId(type, false, new int[]{0});
        new NonStrictExpectations(){
            @NonStrict
            VectorWrapper<?> wrapper;
            {
                batch.getValueVectorId(new SchemaPath("alpha", ExpressionPosition.UNKNOWN));
                result = tfid;
                batch.getValueAccessorById(IntVector.class, tfid.getFieldIds());
                result = this.wrapper;
                this.wrapper.getValueVector();
                result = new IntVector(MaterializedField.create((String)"result", (TypeProtos.MajorType)type), RootAllocatorFactory.newRoot((DrillConfig)ExpressionTest.this.c));
            }
        };
        System.out.println(this.getExpressionCode("1 + 1", batch));
    }

    @Test
    public void testSchemaExpression(final @Injectable RecordBatch batch) throws Exception {
        final TypedFieldId tfid = new TypedFieldId(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), false, new int[]{0});
        new Expectations(){
            {
                batch.getValueVectorId(new SchemaPath("alpha", ExpressionPosition.UNKNOWN));
                result = tfid;
            }
        };
        System.out.println(this.getExpressionCode("1 + alpha", batch));
    }

    @Test(expected=ExpressionParsingException.class)
    public void testExprParseError(@Injectable RecordBatch batch) throws Exception {
        this.getExpressionCode("less than(1, 2)", batch);
    }

    @Test
    public void testExprParseNoError(@Injectable RecordBatch batch) throws Exception {
        this.getExpressionCode("equal(1, 2)", batch);
    }

    private LogicalExpression parseExpr(String expr) throws RecognitionException {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRStringStream(expr));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        ExprParser.parse_return ret = parser.parse();
        return ret.e;
    }

    private String getExpressionCode(String expression, RecordBatch batch) throws Exception {
        LogicalExpression expr = this.parseExpr(expression);
        ErrorCollectorImpl error = new ErrorCollectorImpl();
        LogicalExpression materializedExpr = ExpressionTreeMaterializer.materialize((LogicalExpression)expr, (VectorAccessible)batch, (ErrorCollector)error, (FunctionLookupContext)this.registry);
        if (error.getErrorCount() != 0) {
            logger.error("Failure while materializing expression [{}].  Errors: {}", (Object)expression, (Object)error);
            Assert.assertEquals((long)0L, (long)error.getErrorCount());
        }
        ClassGenerator cg = CodeGenerator.get((TemplateClassDefinition)Projector.TEMPLATE_DEFINITION, (FunctionImplementationRegistry)new FunctionImplementationRegistry(DrillConfig.create())).getRoot();
        cg.addExpr((LogicalExpression)new ValueVectorWriteExpression(new TypedFieldId(materializedExpr.getMajorType(), new int[]{-1}), materializedExpr));
        return cg.getCodeGenerator().generateAndGet();
    }
}

