/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.apache.drill.exec.ExecTest;

public final class EscapeTest1
extends ExecTest {
    public static Timer time(String name) {
        return new Timer(name);
    }

    public static void main(String[] args) {
        EscapeTest1 et = new EscapeTest1();
        Monkey m = new Monkey();
        for (int i = 0; i < 10; ++i) {
            EscapeTest1.time("noalloc").print(et.noAlloc());
            EscapeTest1.time("alloc").print(et.alloc());
            EscapeTest1.time("set noalloc").print(et.setNoAlloc(m));
            EscapeTest1.time("set alloc").print(et.setAlloc(m));
            EscapeTest1.time("get noalloc").print(et.getNoAlloc(m));
            EscapeTest1.time("get alloc").print(et.getAlloc(m));
            EscapeTest1.time("get return alloc").print(et.getReturnAlloc(m));
        }
    }

    public long noAlloc() {
        long sum = 0L;
        for (int i = 0; i < 1000000000; ++i) {
            sum += this.add(i + 1, i + 2);
        }
        return sum;
    }

    public long alloc() {
        long sum = 0L;
        for (int i = 0; i < 1000000000; ++i) {
            Ad ad = new Ad(i + 1, i + 2);
            sum += this.add(ad.x, ad.y);
        }
        return sum;
    }

    public long setAlloc(Monkey m) {
        long sum = 0L;
        for (int i = 0; i < 490000000; ++i) {
            EH h = new EH(i + 1, i + 2);
            m.set(h);
            sum += (long)i;
        }
        return sum;
    }

    public long setNoAlloc(Monkey m) {
        long sum = 0L;
        for (int i = 0; i < 490000000; ++i) {
            m.set(i + 1, i + 2);
            sum += (long)i;
        }
        return sum;
    }

    public long getAlloc(Monkey m) {
        long sum = 0L;
        for (int i = 0; i < 490000000; ++i) {
            RR r = new RR();
            m.get(i, i + 1, r);
            sum += (long)(r.v1 + r.v2);
        }
        return sum;
    }

    public long getNoAlloc(Monkey m) {
        long sum = 0L;
        for (int i = 0; i < 490000000; ++i) {
            int i1 = m.getV1(i);
            int i2 = m.getV2(i + 1);
            sum += (long)(i1 + i2);
        }
        return sum;
    }

    public long getReturnAlloc(Monkey m) {
        long sum = 0L;
        for (int i = 0; i < 490000000; ++i) {
            RR r = m.get(i, i + 1);
            sum += (long)(r.v1 + r.v2);
        }
        return sum;
    }

    public long add(long a, long b) {
        return a + b;
    }

    public static final class Monkey {
        final IntBuffer buf;

        public Monkey() {
            ByteBuffer bb = ByteBuffer.allocateDirect(Integer.MAX_VALUE);
            this.buf = bb.asIntBuffer();
        }

        public final void set(int index, int value) {
            this.buf.put(index, value);
        }

        public final void set(EH a) {
            this.buf.put(a.index, a.value);
        }

        public final int getV1(int index) {
            return this.buf.get(index);
        }

        public final int getV2(int index) {
            return this.buf.get(index);
        }

        public final RR get(int index1, int index2) {
            return new RR(this.buf.get(index1), this.buf.get(index2));
        }

        public final void get(int index1, int index2, RR rr) {
            rr.v1 = this.buf.get(index1);
            rr.v2 = this.buf.get(index2);
        }
    }

    public static final class RR {
        int v1;
        int v2;

        public RR() {
        }

        public RR(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }
    }

    public static final class EH {
        int index;
        int value;

        public EH(int index, int value) {
            this.index = index;
            this.value = value;
        }
    }

    public class Ad {
        long x;
        long y;

        public Ad(long x, long y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Timer {
        long n1 = System.nanoTime();
        String name;

        public Timer(String name) {
            this.name = name;
        }

        public void print(long sum) {
            System.out.println(String.format("Completed %s in %d ms.  Output was %d", this.name, (System.nanoTime() - this.n1) / 1000L / 1000L, sum));
        }
    }
}

