/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.bytecode;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.compile.DrillCheckClassAdapter;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.compile.bytecode.ValueHolderReplacementVisitor;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ReplaceMethodInvoke {
    public static void main(String[] args) throws Exception {
        String k2 = "org/apache/drill/Pickle.class";
        URL url = Resources.getResource((String)"org/apache/drill/Pickle.class");
        byte[] clazz = Resources.toByteArray((URL)url);
        ClassReader cr = new ClassReader(clazz);
        ClassWriter cw = ReplaceMethodInvoke.writer();
        TraceClassVisitor visitor = new TraceClassVisitor((ClassVisitor)cw, (Printer)new Textifier(), new PrintWriter(System.out));
        ValueHolderReplacementVisitor v2 = new ValueHolderReplacementVisitor((ClassVisitor)visitor, true);
        cr.accept((ClassVisitor)v2, 8);
        byte[] output = cw.toByteArray();
        Files.write((byte[])output, (File)new File("/src/scratch/bytes/S.class"));
        ReplaceMethodInvoke.check(output);
        DrillConfig c = DrillConfig.forClient();
        SystemOptionManager m = new SystemOptionManager(c, (PStoreProvider)new LocalPStoreProvider(c));
        m.init();
        try (QueryClassLoader ql = new QueryClassLoader(DrillConfig.create(), (OptionManager)m);){
            ql.injectByteCode("org.apache.drill.Pickle$OutgoingBatch", output);
            Class clz = ql.loadClass("org.apache.drill.Pickle$OutgoingBatch");
            clz.getMethod("x", new Class[0]).invoke(null, new Object[0]);
        }
    }

    private static final void check(byte[] b) {
        ClassReader cr = new ClassReader(b);
        ClassWriter cw = ReplaceMethodInvoke.writer();
        DrillCheckClassAdapter cv = new DrillCheckClassAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DrillCheckClassAdapter.verify((ClassReader)new ClassReader(cw.toByteArray()), (boolean)false, (PrintWriter)pw);
        String checkString = sw.toString();
        if (!checkString.isEmpty()) {
            throw new IllegalStateException(checkString);
        }
    }

    private static ClassWriter writer() {
        ClassWriter cw = new ClassWriter(2);
        return cw;
    }
}

