/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.TestTools;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestLargeFileCompilation
extends BaseTestQuery {
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)150000);
    private static final String LARGE_QUERY_GROUP_BY;
    private static final String LARGE_QUERY_ORDER_BY;
    private static final String LARGE_QUERY_ORDER_BY_WITH_LIMIT;
    private static final String LARGE_QUERY_FILTER;
    private static final String LARGE_QUERY_WRITER;
    private static final int ITERATION_COUNT;
    private static final int NUM_PROJECT_COULMNS = 2000;
    private static final int NUM_ORDERBY_COULMNS = 500;
    private static final int NUM_GROUPBY_COULMNS = 225;
    private static final int NUM_FILTER_COULMNS = 150;

    @Test
    public void testTEXT_WRITER() throws Exception {
        TestLargeFileCompilation.testNoResult("alter session set `%s`='JDK'", "exec.java_compiler");
        TestLargeFileCompilation.testNoResult("use dfs_test.tmp", new Object[0]);
        TestLargeFileCompilation.testNoResult("alter session set `%s`='csv'", "store.format");
        TestLargeFileCompilation.testNoResult(LARGE_QUERY_WRITER, "wide_table_csv");
    }

    @Test
    public void testPARQUET_WRITER() throws Exception {
        TestLargeFileCompilation.testNoResult("alter session set `%s`='JDK'", "exec.java_compiler");
        TestLargeFileCompilation.testNoResult("use dfs_test.tmp", new Object[0]);
        TestLargeFileCompilation.testNoResult("alter session set `%s`='parquet'", "store.format");
        TestLargeFileCompilation.testNoResult(ITERATION_COUNT, LARGE_QUERY_WRITER, "wide_table_parquet");
    }

    @Test
    public void testGROUP_BY() throws Exception {
        TestLargeFileCompilation.testNoResult("alter session set `%s`='JDK'", "exec.java_compiler");
        TestLargeFileCompilation.testNoResult(ITERATION_COUNT, LARGE_QUERY_GROUP_BY, new Object[0]);
    }

    @Test
    @Ignore(value="DRILL-1808")
    public void testEXTERNAL_SORT() throws Exception {
        TestLargeFileCompilation.testNoResult("alter session set `%s`='JDK'", "exec.java_compiler");
        TestLargeFileCompilation.testNoResult(ITERATION_COUNT, LARGE_QUERY_ORDER_BY, new Object[0]);
    }

    @Test
    @Ignore(value="DRILL-1808")
    public void testTOP_N_SORT() throws Exception {
        TestLargeFileCompilation.testNoResult("alter session set `%s`='JDK'", "exec.java_compiler");
        TestLargeFileCompilation.testNoResult(ITERATION_COUNT, LARGE_QUERY_ORDER_BY_WITH_LIMIT, new Object[0]);
    }

    @Test
    public void testFILTER() throws Exception {
        TestLargeFileCompilation.testNoResult("alter session set `%s`='JDK'", "exec.java_compiler");
        TestLargeFileCompilation.testNoResult(ITERATION_COUNT, LARGE_QUERY_FILTER, new Object[0]);
    }

    static {
        int i;
        ITERATION_COUNT = Integer.valueOf(System.getProperty("TestLargeFileCompilation.iteration", "1"));
        StringBuilder sb = new StringBuilder("select\n\t");
        for (i = 0; i < 225; ++i) {
            sb.append("c").append(i).append(", ");
        }
        sb.append("full_name\nfrom (select\n\t");
        for (i = 0; i < 225; ++i) {
            sb.append("employee_id+").append(i).append(" as c").append(i).append(", ");
        }
        sb.append("full_name\nfrom cp.`employee.json`)\ngroup by\n\t");
        for (i = 0; i < 225; ++i) {
            sb.append("c").append(i).append(", ");
        }
        LARGE_QUERY_GROUP_BY = sb.append("full_name").toString();
        sb = new StringBuilder("select\n\t");
        for (i = 0; i < 2000; ++i) {
            sb.append("employee_id+").append(i).append(" as col").append(i).append(", ");
        }
        sb.append("full_name\nfrom cp.`employee.json`\norder by\n\t");
        for (i = 0; i < 500; ++i) {
            sb.append(" col").append(i).append(", ");
        }
        LARGE_QUERY_ORDER_BY = sb.append("full_name").toString();
        LARGE_QUERY_ORDER_BY_WITH_LIMIT = sb.append("\nlimit 1").toString();
        sb = new StringBuilder("select *\n").append("from cp.`employee.json`\n").append("where");
        for (i = 0; i < 150; ++i) {
            sb.append(" employee_id+").append(i).append(" < employee_id ").append(i % 2 == 0 ? "OR" : "AND");
        }
        LARGE_QUERY_FILTER = sb.append(" true").toString();
        sb = new StringBuilder("create table %s as (select \n");
        for (i = 0; i < 2000; ++i) {
            sb.append("employee_id+").append(i).append(" as col").append(i).append(", ");
        }
        LARGE_QUERY_WRITER = sb.append("full_name\nfrom cp.`employee.json` limit 1)").toString();
    }
}

